package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import java.time.Instant
import zio.aws.route53.model.primitives.{TimeStamp, Status}
import scala.jdk.CollectionConverters.*
final case class StatusReport(
    status: Option[Status] = None,
    checkedTime: Option[TimeStamp] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.StatusReport = {
    import StatusReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.StatusReport
      .builder()
      .optionallyWith(
        status.map(value => Status.unwrap(value): java.lang.String)
      )(_.status)
      .optionallyWith(
        checkedTime.map(value => TimeStamp.unwrap(value): Instant)
      )(_.checkedTime)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.StatusReport.ReadOnly =
    zio.aws.route53.model.StatusReport.wrap(buildAwsValue())
}
object StatusReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.StatusReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.StatusReport = zio.aws.route53.model
      .StatusReport(status.map(value => value), checkedTime.map(value => value))
    def status: Option[Status]
    def checkedTime: Option[TimeStamp]
    def getStatus: ZIO[Any, AwsError, Status] =
      AwsError.unwrapOptionField("status", status)
    def getCheckedTime: ZIO[Any, AwsError, TimeStamp] =
      AwsError.unwrapOptionField("checkedTime", checkedTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.StatusReport
  ) extends zio.aws.route53.model.StatusReport.ReadOnly {
    override val status: Option[Status] = scala
      .Option(impl.status())
      .map(value => zio.aws.route53.model.primitives.Status(value))
    override val checkedTime: Option[TimeStamp] = scala
      .Option(impl.checkedTime())
      .map(value => zio.aws.route53.model.primitives.TimeStamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.StatusReport
  ): zio.aws.route53.model.StatusReport.ReadOnly = new Wrapper(impl)
}
