package zio.aws.route53.model
import scala.jdk.CollectionConverters.*
sealed trait TagResourceType {
  def unwrap: software.amazon.awssdk.services.route53.model.TagResourceType
}
object TagResourceType {
  def wrap(
      value: software.amazon.awssdk.services.route53.model.TagResourceType
  ): zio.aws.route53.model.TagResourceType = value match {
    case software.amazon.awssdk.services.route53.model.TagResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.route53.model.TagResourceType.HEALTHCHECK =>
      val r = healthcheck
      r
    case software.amazon.awssdk.services.route53.model.TagResourceType.HOSTEDZONE =>
      val r = hostedzone
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.route53.model.TagResourceType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.TagResourceType =
      software.amazon.awssdk.services.route53.model.TagResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object healthcheck extends zio.aws.route53.model.TagResourceType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.TagResourceType =
      software.amazon.awssdk.services.route53.model.TagResourceType.HEALTHCHECK
  }
  case object hostedzone extends zio.aws.route53.model.TagResourceType {
    override def unwrap
        : software.amazon.awssdk.services.route53.model.TagResourceType =
      software.amazon.awssdk.services.route53.model.TagResourceType.HOSTEDZONE
  }
}
