package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.route53.model.primitives.{
  DNSName,
  TransportProtocol,
  Nameserver,
  RecordDataEntry,
  DNSRCode
}
import scala.jdk.CollectionConverters.*
final case class TestDnsAnswerResponse(
    nameserver: Nameserver,
    recordName: DNSName,
    recordType: zio.aws.route53.model.RRType,
    recordData: Iterable[RecordDataEntry],
    responseCode: DNSRCode,
    protocol: TransportProtocol
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse = {
    import TestDnsAnswerResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse
      .builder()
      .nameserver(Nameserver.unwrap(nameserver): java.lang.String)
      .recordName(DNSName.unwrap(recordName): java.lang.String)
      .recordType(recordType.unwrap)
      .recordData(recordData.map { item =>
        RecordDataEntry.unwrap(item): java.lang.String
      }.asJavaCollection)
      .responseCode(DNSRCode.unwrap(responseCode): java.lang.String)
      .protocol(TransportProtocol.unwrap(protocol): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly =
    zio.aws.route53.model.TestDnsAnswerResponse.wrap(buildAwsValue())
}
object TestDnsAnswerResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.TestDnsAnswerResponse =
      zio.aws.route53.model.TestDnsAnswerResponse(
        nameserver,
        recordName,
        recordType,
        recordData,
        responseCode,
        protocol
      )
    def nameserver: Nameserver
    def recordName: DNSName
    def recordType: zio.aws.route53.model.RRType
    def recordData: List[RecordDataEntry]
    def responseCode: DNSRCode
    def protocol: TransportProtocol
    def getNameserver: ZIO[Any, Nothing, Nameserver] = ZIO.succeed(nameserver)
    def getRecordName: ZIO[Any, Nothing, DNSName] = ZIO.succeed(recordName)
    def getRecordType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(recordType)
    def getRecordData: ZIO[Any, Nothing, List[RecordDataEntry]] =
      ZIO.succeed(recordData)
    def getResponseCode: ZIO[Any, Nothing, DNSRCode] = ZIO.succeed(responseCode)
    def getProtocol: ZIO[Any, Nothing, TransportProtocol] =
      ZIO.succeed(protocol)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse
  ) extends zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly {
    override val nameserver: Nameserver =
      zio.aws.route53.model.primitives.Nameserver(impl.nameserver())
    override val recordName: DNSName =
      zio.aws.route53.model.primitives.DNSName(impl.recordName())
    override val recordType: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.recordType())
    override val recordData: List[RecordDataEntry] = impl
      .recordData()
      .asScala
      .map { item =>
        zio.aws.route53.model.primitives.RecordDataEntry(item)
      }
      .toList
    override val responseCode: DNSRCode =
      zio.aws.route53.model.primitives.DNSRCode(impl.responseCode())
    override val protocol: TransportProtocol =
      zio.aws.route53.model.primitives.TransportProtocol(impl.protocol())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.TestDnsAnswerResponse
  ): zio.aws.route53.model.TestDnsAnswerResponse.ReadOnly = new Wrapper(impl)
}
