package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  TrafficPolicyDocument,
  TrafficPolicyName,
  TrafficPolicyId,
  TrafficPolicyVersion,
  TrafficPolicyComment
}
import scala.jdk.CollectionConverters.*
final case class TrafficPolicy(
    id: TrafficPolicyId,
    version: TrafficPolicyVersion,
    name: TrafficPolicyName,
    `type`: zio.aws.route53.model.RRType,
    document: TrafficPolicyDocument,
    comment: Option[TrafficPolicyComment] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.TrafficPolicy = {
    import TrafficPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.TrafficPolicy
      .builder()
      .id(TrafficPolicyId.unwrap(id): java.lang.String)
      .version(TrafficPolicyVersion.unwrap(version): Integer)
      .name(TrafficPolicyName.unwrap(name): java.lang.String)
      .`type`(`type`.unwrap)
      .document(TrafficPolicyDocument.unwrap(document): java.lang.String)
      .optionallyWith(
        comment.map(value =>
          TrafficPolicyComment.unwrap(value): java.lang.String
        )
      )(_.comment)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.TrafficPolicy.ReadOnly =
    zio.aws.route53.model.TrafficPolicy.wrap(buildAwsValue())
}
object TrafficPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.TrafficPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.TrafficPolicy =
      zio.aws.route53.model.TrafficPolicy(
        id,
        version,
        name,
        `type`,
        document,
        comment.map(value => value)
      )
    def id: TrafficPolicyId
    def version: TrafficPolicyVersion
    def name: TrafficPolicyName
    def `type`: zio.aws.route53.model.RRType
    def document: TrafficPolicyDocument
    def comment: Option[TrafficPolicyComment]
    def getId: ZIO[Any, Nothing, TrafficPolicyId] = ZIO.succeed(id)
    def getVersion: ZIO[Any, Nothing, TrafficPolicyVersion] =
      ZIO.succeed(version)
    def getName: ZIO[Any, Nothing, TrafficPolicyName] = ZIO.succeed(name)
    def getType: ZIO[Any, Nothing, zio.aws.route53.model.RRType] =
      ZIO.succeed(`type`)
    def getDocument: ZIO[Any, Nothing, TrafficPolicyDocument] =
      ZIO.succeed(document)
    def getComment: ZIO[Any, AwsError, TrafficPolicyComment] =
      AwsError.unwrapOptionField("comment", comment)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicy
  ) extends zio.aws.route53.model.TrafficPolicy.ReadOnly {
    override val id: TrafficPolicyId =
      zio.aws.route53.model.primitives.TrafficPolicyId(impl.id())
    override val version: TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion(impl.version())
    override val name: TrafficPolicyName =
      zio.aws.route53.model.primitives.TrafficPolicyName(impl.name())
    override val `type`: zio.aws.route53.model.RRType =
      zio.aws.route53.model.RRType.wrap(impl.`type`())
    override val document: TrafficPolicyDocument =
      zio.aws.route53.model.primitives.TrafficPolicyDocument(impl.document())
    override val comment: Option[TrafficPolicyComment] = scala
      .Option(impl.comment())
      .map(value =>
        zio.aws.route53.model.primitives.TrafficPolicyComment(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.TrafficPolicy
  ): zio.aws.route53.model.TrafficPolicy.ReadOnly = new Wrapper(impl)
}
