package zio.aws.route53.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.{
  HealthThreshold,
  FailureThreshold,
  Inverted,
  Disabled,
  Port,
  EnableSNI,
  SearchString,
  FullyQualifiedDomainName,
  ResourcePath,
  HealthCheckVersion,
  HealthCheckId,
  IPAddress
}
import scala.jdk.CollectionConverters.*
final case class UpdateHealthCheckRequest(
    healthCheckId: HealthCheckId,
    healthCheckVersion: Option[HealthCheckVersion] = None,
    ipAddress: Option[IPAddress] = None,
    port: Option[Port] = None,
    resourcePath: Option[ResourcePath] = None,
    fullyQualifiedDomainName: Option[FullyQualifiedDomainName] = None,
    searchString: Option[SearchString] = None,
    failureThreshold: Option[FailureThreshold] = None,
    inverted: Option[Inverted] = None,
    disabled: Option[Disabled] = None,
    healthThreshold: Option[HealthThreshold] = None,
    childHealthChecks: Option[Iterable[HealthCheckId]] = None,
    enableSNI: Option[EnableSNI] = None,
    regions: Option[Iterable[zio.aws.route53.model.HealthCheckRegion]] = None,
    alarmIdentifier: Option[zio.aws.route53.model.AlarmIdentifier] = None,
    insufficientDataHealthStatus: Option[
      zio.aws.route53.model.InsufficientDataHealthStatus
    ] = None,
    resetElements: Option[
      Iterable[zio.aws.route53.model.ResettableElementName]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest = {
    import UpdateHealthCheckRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
      .builder()
      .healthCheckId(HealthCheckId.unwrap(healthCheckId): java.lang.String)
      .optionallyWith(
        healthCheckVersion.map(value =>
          HealthCheckVersion.unwrap(value): java.lang.Long
        )
      )(_.healthCheckVersion)
      .optionallyWith(
        ipAddress.map(value => IPAddress.unwrap(value): java.lang.String)
      )(_.ipAddress)
      .optionallyWith(port.map(value => Port.unwrap(value): Integer))(_.port)
      .optionallyWith(
        resourcePath.map(value => ResourcePath.unwrap(value): java.lang.String)
      )(_.resourcePath)
      .optionallyWith(
        fullyQualifiedDomainName.map(value =>
          FullyQualifiedDomainName.unwrap(value): java.lang.String
        )
      )(_.fullyQualifiedDomainName)
      .optionallyWith(
        searchString.map(value => SearchString.unwrap(value): java.lang.String)
      )(_.searchString)
      .optionallyWith(
        failureThreshold.map(value => FailureThreshold.unwrap(value): Integer)
      )(_.failureThreshold)
      .optionallyWith(
        inverted.map(value => Inverted.unwrap(value): java.lang.Boolean)
      )(_.inverted)
      .optionallyWith(
        disabled.map(value => Disabled.unwrap(value): java.lang.Boolean)
      )(_.disabled)
      .optionallyWith(
        healthThreshold.map(value => HealthThreshold.unwrap(value): Integer)
      )(_.healthThreshold)
      .optionallyWith(
        childHealthChecks.map(value =>
          value.map { item =>
            HealthCheckId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.childHealthChecks)
      .optionallyWith(
        enableSNI.map(value => EnableSNI.unwrap(value): java.lang.Boolean)
      )(_.enableSNI)
      .optionallyWith(
        regions.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.regionsWithStrings)
      .optionallyWith(alarmIdentifier.map(value => value.buildAwsValue()))(
        _.alarmIdentifier
      )
      .optionallyWith(insufficientDataHealthStatus.map(value => value.unwrap))(
        _.insufficientDataHealthStatus
      )
      .optionallyWith(
        resetElements.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resetElementsWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly =
    zio.aws.route53.model.UpdateHealthCheckRequest.wrap(buildAwsValue())
}
object UpdateHealthCheckRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateHealthCheckRequest =
      zio.aws.route53.model.UpdateHealthCheckRequest(
        healthCheckId,
        healthCheckVersion.map(value => value),
        ipAddress.map(value => value),
        port.map(value => value),
        resourcePath.map(value => value),
        fullyQualifiedDomainName.map(value => value),
        searchString.map(value => value),
        failureThreshold.map(value => value),
        inverted.map(value => value),
        disabled.map(value => value),
        healthThreshold.map(value => value),
        childHealthChecks.map(value => value),
        enableSNI.map(value => value),
        regions.map(value => value),
        alarmIdentifier.map(value => value.asEditable),
        insufficientDataHealthStatus.map(value => value),
        resetElements.map(value => value)
      )
    def healthCheckId: HealthCheckId
    def healthCheckVersion: Option[HealthCheckVersion]
    def ipAddress: Option[IPAddress]
    def port: Option[Port]
    def resourcePath: Option[ResourcePath]
    def fullyQualifiedDomainName: Option[FullyQualifiedDomainName]
    def searchString: Option[SearchString]
    def failureThreshold: Option[FailureThreshold]
    def inverted: Option[Inverted]
    def disabled: Option[Disabled]
    def healthThreshold: Option[HealthThreshold]
    def childHealthChecks: Option[List[HealthCheckId]]
    def enableSNI: Option[EnableSNI]
    def regions: Option[List[zio.aws.route53.model.HealthCheckRegion]]
    def alarmIdentifier: Option[zio.aws.route53.model.AlarmIdentifier.ReadOnly]
    def insufficientDataHealthStatus
        : Option[zio.aws.route53.model.InsufficientDataHealthStatus]
    def resetElements: Option[List[zio.aws.route53.model.ResettableElementName]]
    def getHealthCheckId: ZIO[Any, Nothing, HealthCheckId] =
      ZIO.succeed(healthCheckId)
    def getHealthCheckVersion: ZIO[Any, AwsError, HealthCheckVersion] =
      AwsError.unwrapOptionField("healthCheckVersion", healthCheckVersion)
    def getIpAddress: ZIO[Any, AwsError, IPAddress] =
      AwsError.unwrapOptionField("ipAddress", ipAddress)
    def getPort: ZIO[Any, AwsError, Port] =
      AwsError.unwrapOptionField("port", port)
    def getResourcePath: ZIO[Any, AwsError, ResourcePath] =
      AwsError.unwrapOptionField("resourcePath", resourcePath)
    def getFullyQualifiedDomainName
        : ZIO[Any, AwsError, FullyQualifiedDomainName] = AwsError
      .unwrapOptionField("fullyQualifiedDomainName", fullyQualifiedDomainName)
    def getSearchString: ZIO[Any, AwsError, SearchString] =
      AwsError.unwrapOptionField("searchString", searchString)
    def getFailureThreshold: ZIO[Any, AwsError, FailureThreshold] =
      AwsError.unwrapOptionField("failureThreshold", failureThreshold)
    def getInverted: ZIO[Any, AwsError, Inverted] =
      AwsError.unwrapOptionField("inverted", inverted)
    def getDisabled: ZIO[Any, AwsError, Disabled] =
      AwsError.unwrapOptionField("disabled", disabled)
    def getHealthThreshold: ZIO[Any, AwsError, HealthThreshold] =
      AwsError.unwrapOptionField("healthThreshold", healthThreshold)
    def getChildHealthChecks: ZIO[Any, AwsError, List[HealthCheckId]] =
      AwsError.unwrapOptionField("childHealthChecks", childHealthChecks)
    def getEnableSNI: ZIO[Any, AwsError, EnableSNI] =
      AwsError.unwrapOptionField("enableSNI", enableSNI)
    def getRegions
        : ZIO[Any, AwsError, List[zio.aws.route53.model.HealthCheckRegion]] =
      AwsError.unwrapOptionField("regions", regions)
    def getAlarmIdentifier
        : ZIO[Any, AwsError, zio.aws.route53.model.AlarmIdentifier.ReadOnly] =
      AwsError.unwrapOptionField("alarmIdentifier", alarmIdentifier)
    def getInsufficientDataHealthStatus: ZIO[
      Any,
      AwsError,
      zio.aws.route53.model.InsufficientDataHealthStatus
    ] = AwsError.unwrapOptionField(
      "insufficientDataHealthStatus",
      insufficientDataHealthStatus
    )
    def getResetElements: ZIO[Any, AwsError, List[
      zio.aws.route53.model.ResettableElementName
    ]] = AwsError.unwrapOptionField("resetElements", resetElements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ) extends zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly {
    override val healthCheckId: HealthCheckId =
      zio.aws.route53.model.primitives.HealthCheckId(impl.healthCheckId())
    override val healthCheckVersion: Option[HealthCheckVersion] = scala
      .Option(impl.healthCheckVersion())
      .map(value => zio.aws.route53.model.primitives.HealthCheckVersion(value))
    override val ipAddress: Option[IPAddress] = scala
      .Option(impl.ipAddress())
      .map(value => zio.aws.route53.model.primitives.IPAddress(value))
    override val port: Option[Port] = scala
      .Option(impl.port())
      .map(value => zio.aws.route53.model.primitives.Port(value))
    override val resourcePath: Option[ResourcePath] = scala
      .Option(impl.resourcePath())
      .map(value => zio.aws.route53.model.primitives.ResourcePath(value))
    override val fullyQualifiedDomainName: Option[FullyQualifiedDomainName] =
      scala
        .Option(impl.fullyQualifiedDomainName())
        .map(value =>
          zio.aws.route53.model.primitives.FullyQualifiedDomainName(value)
        )
    override val searchString: Option[SearchString] = scala
      .Option(impl.searchString())
      .map(value => zio.aws.route53.model.primitives.SearchString(value))
    override val failureThreshold: Option[FailureThreshold] = scala
      .Option(impl.failureThreshold())
      .map(value => zio.aws.route53.model.primitives.FailureThreshold(value))
    override val inverted: Option[Inverted] = scala
      .Option(impl.inverted())
      .map(value => zio.aws.route53.model.primitives.Inverted(value))
    override val disabled: Option[Disabled] = scala
      .Option(impl.disabled())
      .map(value => zio.aws.route53.model.primitives.Disabled(value))
    override val healthThreshold: Option[HealthThreshold] = scala
      .Option(impl.healthThreshold())
      .map(value => zio.aws.route53.model.primitives.HealthThreshold(value))
    override val childHealthChecks: Option[List[HealthCheckId]] = scala
      .Option(impl.childHealthChecks())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.primitives.HealthCheckId(item)
        }.toList
      )
    override val enableSNI: Option[EnableSNI] = scala
      .Option(impl.enableSNI())
      .map(value => zio.aws.route53.model.primitives.EnableSNI(value))
    override val regions
        : Option[List[zio.aws.route53.model.HealthCheckRegion]] = scala
      .Option(impl.regions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.HealthCheckRegion.wrap(item)
        }.toList
      )
    override val alarmIdentifier
        : Option[zio.aws.route53.model.AlarmIdentifier.ReadOnly] = scala
      .Option(impl.alarmIdentifier())
      .map(value => zio.aws.route53.model.AlarmIdentifier.wrap(value))
    override val insufficientDataHealthStatus
        : Option[zio.aws.route53.model.InsufficientDataHealthStatus] = scala
      .Option(impl.insufficientDataHealthStatus())
      .map(value =>
        zio.aws.route53.model.InsufficientDataHealthStatus.wrap(value)
      )
    override val resetElements
        : Option[List[zio.aws.route53.model.ResettableElementName]] = scala
      .Option(impl.resetElements())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.route53.model.ResettableElementName.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateHealthCheckRequest
  ): zio.aws.route53.model.UpdateHealthCheckRequest.ReadOnly = new Wrapper(impl)
}
