package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateHostedZoneCommentResponse(
    hostedZone: zio.aws.route53.model.HostedZone
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse = {
    import UpdateHostedZoneCommentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse
      .builder()
      .hostedZone(hostedZone.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly =
    zio.aws.route53.model.UpdateHostedZoneCommentResponse.wrap(buildAwsValue())
}
object UpdateHostedZoneCommentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.UpdateHostedZoneCommentResponse =
      zio.aws.route53.model
        .UpdateHostedZoneCommentResponse(hostedZone.asEditable)
    def hostedZone: zio.aws.route53.model.HostedZone.ReadOnly
    def getHostedZone
        : ZIO[Any, Nothing, zio.aws.route53.model.HostedZone.ReadOnly] =
      ZIO.succeed(hostedZone)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse
  ) extends zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly {
    override val hostedZone: zio.aws.route53.model.HostedZone.ReadOnly =
      zio.aws.route53.model.HostedZone.wrap(impl.hostedZone())
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.UpdateHostedZoneCommentResponse
  ): zio.aws.route53.model.UpdateHostedZoneCommentResponse.ReadOnly =
    new Wrapper(impl)
}
