package zio.aws.route53.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.route53.model.primitives.VPCId
import scala.jdk.CollectionConverters.*
final case class VPC(
    vpcRegion: Option[zio.aws.route53.model.VPCRegion] = None,
    vpcId: Option[VPCId] = None
) {
  def buildAwsValue(): software.amazon.awssdk.services.route53.model.VPC = {
    import VPC.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.route53.model.VPC
      .builder()
      .optionallyWith(vpcRegion.map(value => value.unwrap))(_.vpcRegion)
      .optionallyWith(
        vpcId.map(value => VPCId.unwrap(value): java.lang.String)
      )(_.vpcId)
      .build()
  }
  def asReadOnly: zio.aws.route53.model.VPC.ReadOnly =
    zio.aws.route53.model.VPC.wrap(buildAwsValue())
}
object VPC {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.route53.model.VPC] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.route53.model.VPC = zio.aws.route53.model
      .VPC(vpcRegion.map(value => value), vpcId.map(value => value))
    def vpcRegion: Option[zio.aws.route53.model.VPCRegion]
    def vpcId: Option[VPCId]
    def getVpcRegion: ZIO[Any, AwsError, zio.aws.route53.model.VPCRegion] =
      AwsError.unwrapOptionField("vpcRegion", vpcRegion)
    def getVpcId: ZIO[Any, AwsError, VPCId] =
      AwsError.unwrapOptionField("vpcId", vpcId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.route53.model.VPC
  ) extends zio.aws.route53.model.VPC.ReadOnly {
    override val vpcRegion: Option[zio.aws.route53.model.VPCRegion] = scala
      .Option(impl.vpcRegion())
      .map(value => zio.aws.route53.model.VPCRegion.wrap(value))
    override val vpcId: Option[VPCId] = scala
      .Option(impl.vpcId())
      .map(value => zio.aws.route53.model.primitives.VPCId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.route53.model.VPC
  ): zio.aws.route53.model.VPC.ReadOnly = new Wrapper(impl)
}
