package zio.aws.route53
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.route53.model.primitives.TagValue.Type
import zio.aws.route53.model.primitives.{
  DNSName,
  IPAddressCidr,
  RecordDataEntry,
  HealthCheckId,
  TagResourceId,
  TagKey
}
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object AWSAccountID extends Subtype[String]
    type AWSAccountID = zio.aws.route53.model.primitives.AWSAccountID.Type
    object AlarmName extends Subtype[String]
    type AlarmName = zio.aws.route53.model.primitives.AlarmName.Type
    object AliasHealthEnabled extends Subtype[Boolean]
    type AliasHealthEnabled =
      zio.aws.route53.model.primitives.AliasHealthEnabled.Type
    object AssociateVPCComment extends Subtype[String]
    type AssociateVPCComment =
      zio.aws.route53.model.primitives.AssociateVPCComment.Type
    object CloudWatchLogsLogGroupArn extends Subtype[String]
    type CloudWatchLogsLogGroupArn =
      zio.aws.route53.model.primitives.CloudWatchLogsLogGroupArn.Type
    object DNSName extends Subtype[String]
    type DNSName = zio.aws.route53.model.primitives.DNSName.Type
    object DNSRCode extends Subtype[String]
    type DNSRCode = zio.aws.route53.model.primitives.DNSRCode.Type
    object DimensionField extends Subtype[String]
    type DimensionField = zio.aws.route53.model.primitives.DimensionField.Type
    object Disabled extends Subtype[Boolean]
    type Disabled = zio.aws.route53.model.primitives.Disabled.Type
    object DisassociateVPCComment extends Subtype[String]
    type DisassociateVPCComment =
      zio.aws.route53.model.primitives.DisassociateVPCComment.Type
    object EnableSNI extends Subtype[Boolean]
    type EnableSNI = zio.aws.route53.model.primitives.EnableSNI.Type
    object EvaluationPeriods extends Subtype[Int]
    type EvaluationPeriods =
      zio.aws.route53.model.primitives.EvaluationPeriods.Type
    object FailureThreshold extends Subtype[Int]
    type FailureThreshold =
      zio.aws.route53.model.primitives.FailureThreshold.Type
    object FullyQualifiedDomainName extends Subtype[String]
    type FullyQualifiedDomainName =
      zio.aws.route53.model.primitives.FullyQualifiedDomainName.Type
    object GeoLocationContinentCode extends Subtype[String]
    type GeoLocationContinentCode =
      zio.aws.route53.model.primitives.GeoLocationContinentCode.Type
    object GeoLocationContinentName extends Subtype[String]
    type GeoLocationContinentName =
      zio.aws.route53.model.primitives.GeoLocationContinentName.Type
    object GeoLocationCountryCode extends Subtype[String]
    type GeoLocationCountryCode =
      zio.aws.route53.model.primitives.GeoLocationCountryCode.Type
    object GeoLocationCountryName extends Subtype[String]
    type GeoLocationCountryName =
      zio.aws.route53.model.primitives.GeoLocationCountryName.Type
    object GeoLocationSubdivisionCode extends Subtype[String]
    type GeoLocationSubdivisionCode =
      zio.aws.route53.model.primitives.GeoLocationSubdivisionCode.Type
    object GeoLocationSubdivisionName extends Subtype[String]
    type GeoLocationSubdivisionName =
      zio.aws.route53.model.primitives.GeoLocationSubdivisionName.Type
    object HealthCheckCount extends Subtype[Long]
    type HealthCheckCount =
      zio.aws.route53.model.primitives.HealthCheckCount.Type
    object HealthCheckId extends Subtype[String]
    type HealthCheckId = zio.aws.route53.model.primitives.HealthCheckId.Type
    object HealthCheckNonce extends Subtype[String]
    type HealthCheckNonce =
      zio.aws.route53.model.primitives.HealthCheckNonce.Type
    object HealthCheckVersion extends Subtype[Long]
    type HealthCheckVersion =
      zio.aws.route53.model.primitives.HealthCheckVersion.Type
    object HealthThreshold extends Subtype[Int]
    type HealthThreshold = zio.aws.route53.model.primitives.HealthThreshold.Type
    object HostedZoneCount extends Subtype[Long]
    type HostedZoneCount = zio.aws.route53.model.primitives.HostedZoneCount.Type
    object HostedZoneOwningService extends Subtype[String]
    type HostedZoneOwningService =
      zio.aws.route53.model.primitives.HostedZoneOwningService.Type
    object HostedZoneRRSetCount extends Subtype[Long]
    type HostedZoneRRSetCount =
      zio.aws.route53.model.primitives.HostedZoneRRSetCount.Type
    object IPAddress extends Subtype[String]
    type IPAddress = zio.aws.route53.model.primitives.IPAddress.Type
    object IPAddressCidr extends Subtype[String]
    type IPAddressCidr = zio.aws.route53.model.primitives.IPAddressCidr.Type
    object Inverted extends Subtype[Boolean]
    type Inverted = zio.aws.route53.model.primitives.Inverted.Type
    object IsPrivateZone extends Subtype[Boolean]
    type IsPrivateZone = zio.aws.route53.model.primitives.IsPrivateZone.Type
    object LimitValue extends Subtype[Long]
    type LimitValue = zio.aws.route53.model.primitives.LimitValue.Type
    object MaxResults extends Subtype[String]
    type MaxResults = zio.aws.route53.model.primitives.MaxResults.Type
    object MeasureLatency extends Subtype[Boolean]
    type MeasureLatency = zio.aws.route53.model.primitives.MeasureLatency.Type
    object Message extends Subtype[String]
    type Message = zio.aws.route53.model.primitives.Message.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.route53.model.primitives.MetricName.Type
    object Nameserver extends Subtype[String]
    type Nameserver = zio.aws.route53.model.primitives.Nameserver.Type
    object Namespace extends Subtype[String]
    type Namespace = zio.aws.route53.model.primitives.Namespace.Type
    object Nonce extends Subtype[String]
    type Nonce = zio.aws.route53.model.primitives.Nonce.Type
    object PageMarker extends Subtype[String]
    type PageMarker = zio.aws.route53.model.primitives.PageMarker.Type
    object PageMaxItems extends Subtype[String]
    type PageMaxItems = zio.aws.route53.model.primitives.PageMaxItems.Type
    object PageTruncated extends Subtype[Boolean]
    type PageTruncated = zio.aws.route53.model.primitives.PageTruncated.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken = zio.aws.route53.model.primitives.PaginationToken.Type
    object Period extends Subtype[Int]
    type Period = zio.aws.route53.model.primitives.Period.Type
    object Port extends Subtype[Int]
    type Port = zio.aws.route53.model.primitives.Port.Type
    object QueryLoggingConfigId extends Subtype[String]
    type QueryLoggingConfigId =
      zio.aws.route53.model.primitives.QueryLoggingConfigId.Type
    object RData extends Subtype[String]
    type RData = zio.aws.route53.model.primitives.RData.Type
    object RecordDataEntry extends Subtype[String]
    type RecordDataEntry = zio.aws.route53.model.primitives.RecordDataEntry.Type
    object RequestInterval extends Subtype[Int]
    type RequestInterval = zio.aws.route53.model.primitives.RequestInterval.Type
    object ResourceDescription extends Subtype[String]
    type ResourceDescription =
      zio.aws.route53.model.primitives.ResourceDescription.Type
    object ResourceId extends Subtype[String]
    type ResourceId = zio.aws.route53.model.primitives.ResourceId.Type
    object ResourcePath extends Subtype[String]
    type ResourcePath = zio.aws.route53.model.primitives.ResourcePath.Type
    object ResourceRecordSetIdentifier extends Subtype[String]
    type ResourceRecordSetIdentifier =
      zio.aws.route53.model.primitives.ResourceRecordSetIdentifier.Type
    object ResourceRecordSetMultiValueAnswer extends Subtype[Boolean]
    type ResourceRecordSetMultiValueAnswer =
      zio.aws.route53.model.primitives.ResourceRecordSetMultiValueAnswer.Type
    object ResourceRecordSetWeight extends Subtype[Long]
    type ResourceRecordSetWeight =
      zio.aws.route53.model.primitives.ResourceRecordSetWeight.Type
    object ResourceURI extends Subtype[String]
    type ResourceURI = zio.aws.route53.model.primitives.ResourceURI.Type
    object RoutingControlArn extends Subtype[String]
    type RoutingControlArn =
      zio.aws.route53.model.primitives.RoutingControlArn.Type
    object SearchString extends Subtype[String]
    type SearchString = zio.aws.route53.model.primitives.SearchString.Type
    object ServeSignature extends Subtype[String]
    type ServeSignature = zio.aws.route53.model.primitives.ServeSignature.Type
    object ServicePrincipal extends Subtype[String]
    type ServicePrincipal =
      zio.aws.route53.model.primitives.ServicePrincipal.Type
    object SigningKeyInteger extends Subtype[Int]
    type SigningKeyInteger =
      zio.aws.route53.model.primitives.SigningKeyInteger.Type
    object SigningKeyName extends Subtype[String]
    type SigningKeyName = zio.aws.route53.model.primitives.SigningKeyName.Type
    object SigningKeyStatus extends Subtype[String]
    type SigningKeyStatus =
      zio.aws.route53.model.primitives.SigningKeyStatus.Type
    object SigningKeyStatusMessage extends Subtype[String]
    type SigningKeyStatusMessage =
      zio.aws.route53.model.primitives.SigningKeyStatusMessage.Type
    object SigningKeyString extends Subtype[String]
    type SigningKeyString =
      zio.aws.route53.model.primitives.SigningKeyString.Type
    object SigningKeyTag extends Subtype[Int]
    type SigningKeyTag = zio.aws.route53.model.primitives.SigningKeyTag.Type
    object Status extends Subtype[String]
    type Status = zio.aws.route53.model.primitives.Status.Type
    object SubnetMask extends Subtype[String]
    type SubnetMask = zio.aws.route53.model.primitives.SubnetMask.Type
    object TTL extends Subtype[Long]
    type TTL = zio.aws.route53.model.primitives.TTL.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.route53.model.primitives.TagKey.Type
    object TagResourceId extends Subtype[String]
    type TagResourceId = zio.aws.route53.model.primitives.TagResourceId.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.route53.model.primitives.TagValue.Type
    object Threshold extends Subtype[Double]
    type Threshold = zio.aws.route53.model.primitives.Threshold.Type
    object TimeStamp extends Subtype[Instant]
    type TimeStamp = zio.aws.route53.model.primitives.TimeStamp.Type
    object TrafficPolicyComment extends Subtype[String]
    type TrafficPolicyComment =
      zio.aws.route53.model.primitives.TrafficPolicyComment.Type
    object TrafficPolicyDocument extends Subtype[String]
    type TrafficPolicyDocument =
      zio.aws.route53.model.primitives.TrafficPolicyDocument.Type
    object TrafficPolicyId extends Subtype[String]
    type TrafficPolicyId = zio.aws.route53.model.primitives.TrafficPolicyId.Type
    object TrafficPolicyInstanceCount extends Subtype[Int]
    type TrafficPolicyInstanceCount =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceCount.Type
    object TrafficPolicyInstanceId extends Subtype[String]
    type TrafficPolicyInstanceId =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceId.Type
    object TrafficPolicyInstanceState extends Subtype[String]
    type TrafficPolicyInstanceState =
      zio.aws.route53.model.primitives.TrafficPolicyInstanceState.Type
    object TrafficPolicyName extends Subtype[String]
    type TrafficPolicyName =
      zio.aws.route53.model.primitives.TrafficPolicyName.Type
    object TrafficPolicyVersion extends Subtype[Int]
    type TrafficPolicyVersion =
      zio.aws.route53.model.primitives.TrafficPolicyVersion.Type
    object TrafficPolicyVersionMarker extends Subtype[String]
    type TrafficPolicyVersionMarker =
      zio.aws.route53.model.primitives.TrafficPolicyVersionMarker.Type
    object TransportProtocol extends Subtype[String]
    type TransportProtocol =
      zio.aws.route53.model.primitives.TransportProtocol.Type
    object UsageCount extends Subtype[Long]
    type UsageCount = zio.aws.route53.model.primitives.UsageCount.Type
    object VPCId extends Subtype[String]
    type VPCId = zio.aws.route53.model.primitives.VPCId.Type
  }
  type Changes = List[zio.aws.route53.model.Change]
  type CheckerIpRanges = List[IPAddressCidr]
  type ChildHealthCheckList = List[HealthCheckId]
  type DelegationSetNameServers = List[DNSName]
  type DelegationSets = List[zio.aws.route53.model.DelegationSet]
  type DimensionList = List[zio.aws.route53.model.Dimension]
  type GeoLocationDetailsList = List[zio.aws.route53.model.GeoLocationDetails]
  type HealthCheckObservations =
    List[zio.aws.route53.model.HealthCheckObservation]
  type HealthCheckRegionList = List[zio.aws.route53.model.HealthCheckRegion]
  type HealthChecks = List[zio.aws.route53.model.HealthCheck]
  type HostedZoneSummaries = List[zio.aws.route53.model.HostedZoneSummary]
  type HostedZones = List[zio.aws.route53.model.HostedZone]
  type KeySigningKeys = List[zio.aws.route53.model.KeySigningKey]
  type QueryLoggingConfigs = List[zio.aws.route53.model.QueryLoggingConfig]
  type RecordData = List[RecordDataEntry]
  type ResettableElementNameList =
    List[zio.aws.route53.model.ResettableElementName]
  type ResourceRecordSets = List[zio.aws.route53.model.ResourceRecordSet]
  type ResourceRecords = List[zio.aws.route53.model.ResourceRecord]
  type ResourceTagSetList = List[zio.aws.route53.model.ResourceTagSet]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.route53.model.Tag]
  type TagResourceIdList = List[TagResourceId]
  type TrafficPolicies = List[zio.aws.route53.model.TrafficPolicy]
  type TrafficPolicyInstances =
    List[zio.aws.route53.model.TrafficPolicyInstance]
  type TrafficPolicySummaries = List[zio.aws.route53.model.TrafficPolicySummary]
  type VPCs = List[zio.aws.route53.model.VPC]
}
