package zio.aws.rum
import zio.aws.rum.model.AppMonitorSummary.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.rum.model.primitives.EventData
import zio.aws.rum.model.{
  GetAppMonitorDataRequest,
  ListTagsForResourceRequest,
  ListAppMonitorsRequest,
  UntagResourceRequest,
  CreateAppMonitorRequest,
  UpdateAppMonitorRequest,
  DeleteAppMonitorRequest,
  PutRumEventsRequest,
  TagResourceRequest,
  GetAppMonitorRequest
}
import software.amazon.awssdk.services.rum.{
  RumAsyncClientBuilder,
  RumAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import software.amazon.awssdk.services.rum.model.{
  GetAppMonitorDataResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  DeleteAppMonitorResponse,
  AppMonitorSummary,
  GetAppMonitorResponse,
  CreateAppMonitorResponse,
  ListAppMonitorsResponse,
  UpdateAppMonitorResponse,
  PutRumEventsResponse,
  TagResourceResponse
}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait Rum extends AspectSupport[Rum] {
  val api: RumAsyncClient
  def deleteAppMonitor(
      request: DeleteAppMonitorRequest
  ): IO[AwsError, zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly]
  def putRumEvents(
      request: PutRumEventsRequest
  ): IO[AwsError, zio.aws.rum.model.PutRumEventsResponse.ReadOnly]
  def listAppMonitors(
      request: ListAppMonitorsRequest
  ): ZStream[Any, AwsError, ReadOnly]
  def listAppMonitorsPaginated(
      request: ListAppMonitorsRequest
  ): IO[AwsError, zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.rum.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly]
  def getAppMonitorData(
      request: GetAppMonitorDataRequest
  ): ZStream[Any, AwsError, EventData]
  def getAppMonitorDataPaginated(
      request: GetAppMonitorDataRequest
  ): IO[AwsError, zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly]
  def tagResource(
      request: TagResourceRequest
  ): IO[AwsError, zio.aws.rum.model.TagResourceResponse.ReadOnly]
  def updateAppMonitor(
      request: UpdateAppMonitorRequest
  ): IO[AwsError, zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly]
  def getAppMonitor(
      request: GetAppMonitorRequest
  ): IO[AwsError, zio.aws.rum.model.GetAppMonitorResponse.ReadOnly]
  def createAppMonitor(
      request: CreateAppMonitorRequest
  ): IO[AwsError, zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly]
}
object Rum {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Rum] = customized(identity)
  def customized(
      customization: RumAsyncClientBuilder => RumAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Rum] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: RumAsyncClientBuilder => RumAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Rum] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = RumAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[RumAsyncClient, RumAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[RumAsyncClient, RumAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new RumImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class RumImpl[R](
      override val api: RumAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Rum
      with AwsServiceBase[R] {
    override val serviceName: String = "Rum"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): RumImpl[R1] = new RumImpl(api, newAspect, r)
    def deleteAppMonitor(
        request: DeleteAppMonitorRequest
    ): IO[AwsError, zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest,
        DeleteAppMonitorResponse
      ]("deleteAppMonitor", api.deleteAppMonitor)(request.buildAwsValue())
        .map(zio.aws.rum.model.DeleteAppMonitorResponse.wrap)
        .provideEnvironment(r)
    def putRumEvents(
        request: PutRumEventsRequest
    ): IO[AwsError, zio.aws.rum.model.PutRumEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.PutRumEventsRequest,
        PutRumEventsResponse
      ]("putRumEvents", api.putRumEvents)(request.buildAwsValue())
        .map(zio.aws.rum.model.PutRumEventsResponse.wrap)
        .provideEnvironment(r)
    def listAppMonitors(
        request: ListAppMonitorsRequest
    ): ZStream[Any, AwsError, ReadOnly] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest,
      ListAppMonitorsResponse,
      AppMonitorSummary
    ](
      "listAppMonitors",
      api.listAppMonitors,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.appMonitorSummaries().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rum.model.AppMonitorSummary.wrap(item))
      .provideEnvironment(r)
    def listAppMonitorsPaginated(
        request: ListAppMonitorsRequest
    ): IO[AwsError, zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest,
        ListAppMonitorsResponse
      ]("listAppMonitors", api.listAppMonitors)(request.buildAwsValue())
        .map(zio.aws.rum.model.ListAppMonitorsResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.rum.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.rum.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.rum.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def getAppMonitorData(
        request: GetAppMonitorDataRequest
    ): ZStream[Any, AwsError, EventData] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest,
      GetAppMonitorDataResponse,
      java.lang.String
    ](
      "getAppMonitorData",
      api.getAppMonitorData,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.events().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.rum.model.primitives.EventData(item))
      .provideEnvironment(r)
    def getAppMonitorDataPaginated(
        request: GetAppMonitorDataRequest
    ): IO[AwsError, zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest,
        GetAppMonitorDataResponse
      ]("getAppMonitorData", api.getAppMonitorData)(request.buildAwsValue())
        .map(zio.aws.rum.model.GetAppMonitorDataResponse.wrap)
        .provideEnvironment(r)
    def tagResource(
        request: TagResourceRequest
    ): IO[AwsError, zio.aws.rum.model.TagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.rum.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def updateAppMonitor(
        request: UpdateAppMonitorRequest
    ): IO[AwsError, zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.UpdateAppMonitorRequest,
        UpdateAppMonitorResponse
      ]("updateAppMonitor", api.updateAppMonitor)(request.buildAwsValue())
        .map(zio.aws.rum.model.UpdateAppMonitorResponse.wrap)
        .provideEnvironment(r)
    def getAppMonitor(
        request: GetAppMonitorRequest
    ): IO[AwsError, zio.aws.rum.model.GetAppMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.GetAppMonitorRequest,
        GetAppMonitorResponse
      ]("getAppMonitor", api.getAppMonitor)(request.buildAwsValue())
        .map(zio.aws.rum.model.GetAppMonitorResponse.wrap)
        .provideEnvironment(r)
    def createAppMonitor(
        request: CreateAppMonitorRequest
    ): IO[AwsError, zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest,
        CreateAppMonitorResponse
      ]("createAppMonitor", api.createAppMonitor)(request.buildAwsValue())
        .map(zio.aws.rum.model.CreateAppMonitorResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteAppMonitor(request: DeleteAppMonitorRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteAppMonitor(request))
  def putRumEvents(request: PutRumEventsRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.PutRumEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.putRumEvents(request))
  def listAppMonitors(
      request: ListAppMonitorsRequest
  ): ZStream[zio.aws.rum.Rum, AwsError, ReadOnly] =
    ZStream.serviceWithStream(_.listAppMonitors(request))
  def listAppMonitorsPaginated(request: ListAppMonitorsRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listAppMonitorsPaginated(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def getAppMonitorData(
      request: GetAppMonitorDataRequest
  ): ZStream[zio.aws.rum.Rum, AwsError, EventData] =
    ZStream.serviceWithStream(_.getAppMonitorData(request))
  def getAppMonitorDataPaginated(request: GetAppMonitorDataRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppMonitorDataPaginated(request))
  def tagResource(request: TagResourceRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.TagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.tagResource(request))
  def updateAppMonitor(request: UpdateAppMonitorRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateAppMonitor(request))
  def getAppMonitor(request: GetAppMonitorRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.GetAppMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getAppMonitor(request))
  def createAppMonitor(request: CreateAppMonitorRequest): ZIO[
    zio.aws.rum.Rum,
    AwsError,
    zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createAppMonitor(request))
}
