package zio.aws.rum
import zio.aws.rum.model.AppMonitorSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.rum.model.primitives.EventData
import zio.aws.rum.model.{
  GetAppMonitorDataRequest,
  ListTagsForResourceRequest,
  ListAppMonitorsRequest,
  UntagResourceRequest,
  CreateAppMonitorRequest,
  UpdateAppMonitorRequest,
  DeleteAppMonitorRequest,
  PutRumEventsRequest,
  TagResourceRequest,
  GetAppMonitorRequest
}
import software.amazon.awssdk.services.rum.RumAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object RumMock extends Mock[Rum] {
  object DeleteAppMonitor
      extends Effect[
        DeleteAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly
      ]
  object PutRumEvents
      extends Effect[
        PutRumEventsRequest,
        AwsError,
        zio.aws.rum.model.PutRumEventsResponse.ReadOnly
      ]
  object ListAppMonitors
      extends Stream[ListAppMonitorsRequest, AwsError, ReadOnly]
  object ListAppMonitorsPaginated
      extends Effect[
        ListAppMonitorsRequest,
        AwsError,
        zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.rum.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetAppMonitorData
      extends Stream[GetAppMonitorDataRequest, AwsError, EventData]
  object GetAppMonitorDataPaginated
      extends Effect[
        GetAppMonitorDataRequest,
        AwsError,
        zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.rum.model.TagResourceResponse.ReadOnly
      ]
  object UpdateAppMonitor
      extends Effect[
        UpdateAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly
      ]
  object GetAppMonitor
      extends Effect[
        GetAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.GetAppMonitorResponse.ReadOnly
      ]
  object CreateAppMonitor
      extends Effect[
        CreateAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Rum] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new Rum {
          val api: RumAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : Rum = this
          def deleteAppMonitor(
              request: DeleteAppMonitorRequest
          ): IO[AwsError, zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly] =
            proxy(DeleteAppMonitor, request)
          def putRumEvents(
              request: PutRumEventsRequest
          ): IO[AwsError, zio.aws.rum.model.PutRumEventsResponse.ReadOnly] =
            proxy(PutRumEvents, request)
          def listAppMonitors(
              request: ListAppMonitorsRequest
          ): ZStream[Any, AwsError, ReadOnly] =
            rts.unsafeRun(proxy(ListAppMonitors, request))
          def listAppMonitorsPaginated(
              request: ListAppMonitorsRequest
          ): IO[AwsError, zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly] =
            proxy(ListAppMonitorsPaginated, request)
          def untagResource(
              request: UntagResourceRequest
          ): IO[AwsError, zio.aws.rum.model.UntagResourceResponse.ReadOnly] =
            proxy(UntagResource, request)
          def listTagsForResource(request: ListTagsForResourceRequest): IO[
            AwsError,
            zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly
          ] = proxy(ListTagsForResource, request)
          def getAppMonitorData(
              request: GetAppMonitorDataRequest
          ): ZStream[Any, AwsError, EventData] =
            rts.unsafeRun(proxy(GetAppMonitorData, request))
          def getAppMonitorDataPaginated(request: GetAppMonitorDataRequest): IO[
            AwsError,
            zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly
          ] = proxy(GetAppMonitorDataPaginated, request)
          def tagResource(
              request: TagResourceRequest
          ): IO[AwsError, zio.aws.rum.model.TagResourceResponse.ReadOnly] =
            proxy(TagResource, request)
          def updateAppMonitor(
              request: UpdateAppMonitorRequest
          ): IO[AwsError, zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly] =
            proxy(UpdateAppMonitor, request)
          def getAppMonitor(
              request: GetAppMonitorRequest
          ): IO[AwsError, zio.aws.rum.model.GetAppMonitorResponse.ReadOnly] =
            proxy(GetAppMonitor, request)
          def createAppMonitor(
              request: CreateAppMonitorRequest
          ): IO[AwsError, zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly] =
            proxy(CreateAppMonitor, request)
        }
      }
    }
  }
}
