package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  TagValue,
  AppMonitorId,
  AppMonitorName,
  AppMonitorDomain,
  ISOTimestampString,
  TagKey
}
import scala.jdk.CollectionConverters._
final case class AppMonitor(
    appMonitorConfiguration: Optional[
      zio.aws.rum.model.AppMonitorConfiguration
    ] = Optional.Absent,
    created: Optional[ISOTimestampString] = Optional.Absent,
    dataStorage: Optional[zio.aws.rum.model.DataStorage] = Optional.Absent,
    domain: Optional[AppMonitorDomain] = Optional.Absent,
    id: Optional[AppMonitorId] = Optional.Absent,
    lastModified: Optional[ISOTimestampString] = Optional.Absent,
    name: Optional[AppMonitorName] = Optional.Absent,
    state: Optional[zio.aws.rum.model.StateEnum] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.AppMonitor = {
    import AppMonitor.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.AppMonitor
      .builder()
      .optionallyWith(
        appMonitorConfiguration.map(value => value.buildAwsValue())
      )(_.appMonitorConfiguration)
      .optionallyWith(
        created.map(value => ISOTimestampString.unwrap(value): java.lang.String)
      )(_.created)
      .optionallyWith(dataStorage.map(value => value.buildAwsValue()))(
        _.dataStorage
      )
      .optionallyWith(
        domain.map(value => AppMonitorDomain.unwrap(value): java.lang.String)
      )(_.domain)
      .optionallyWith(
        id.map(value => AppMonitorId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastModified.map(value =>
          ISOTimestampString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        name.map(value => AppMonitorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.AppMonitor.ReadOnly =
    zio.aws.rum.model.AppMonitor.wrap(buildAwsValue())
}
object AppMonitor {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.AppMonitor] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.AppMonitor = zio.aws.rum.model.AppMonitor(
      appMonitorConfiguration.map(value => value.asEditable),
      created.map(value => value),
      dataStorage.map(value => value.asEditable),
      domain.map(value => value),
      id.map(value => value),
      lastModified.map(value => value),
      name.map(value => value),
      state.map(value => value),
      tags.map(value => value)
    )
    def appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly]
    def created: Optional[ISOTimestampString]
    def dataStorage: Optional[zio.aws.rum.model.DataStorage.ReadOnly]
    def domain: Optional[AppMonitorDomain]
    def id: Optional[AppMonitorId]
    def lastModified: Optional[ISOTimestampString]
    def name: Optional[AppMonitorName]
    def state: Optional[zio.aws.rum.model.StateEnum]
    def tags: Optional[Map[TagKey, TagValue]]
    def getAppMonitorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rum.model.AppMonitorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appMonitorConfiguration",
      appMonitorConfiguration
    )
    def getCreated: ZIO[Any, AwsError, ISOTimestampString] =
      AwsError.unwrapOptionField("created", created)
    def getDataStorage
        : ZIO[Any, AwsError, zio.aws.rum.model.DataStorage.ReadOnly] =
      AwsError.unwrapOptionField("dataStorage", dataStorage)
    def getDomain: ZIO[Any, AwsError, AppMonitorDomain] =
      AwsError.unwrapOptionField("domain", domain)
    def getId: ZIO[Any, AwsError, AppMonitorId] =
      AwsError.unwrapOptionField("id", id)
    def getLastModified: ZIO[Any, AwsError, ISOTimestampString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getName: ZIO[Any, AwsError, AppMonitorName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.rum.model.StateEnum] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.AppMonitor
  ) extends zio.aws.rum.model.AppMonitor.ReadOnly {
    override val appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appMonitorConfiguration())
        .map(value => zio.aws.rum.model.AppMonitorConfiguration.wrap(value))
    override val created: Optional[ISOTimestampString] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.rum.model.primitives.ISOTimestampString(value))
    override val dataStorage: Optional[zio.aws.rum.model.DataStorage.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dataStorage())
        .map(value => zio.aws.rum.model.DataStorage.wrap(value))
    override val domain: Optional[AppMonitorDomain] = zio.aws.core.internal
      .optionalFromNullable(impl.domain())
      .map(value => zio.aws.rum.model.primitives.AppMonitorDomain(value))
    override val id: Optional[AppMonitorId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.rum.model.primitives.AppMonitorId(value))
    override val lastModified: Optional[ISOTimestampString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModified())
        .map(value => zio.aws.rum.model.primitives.ISOTimestampString(value))
    override val name: Optional[AppMonitorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.rum.model.primitives.AppMonitorName(value))
    override val state: Optional[zio.aws.rum.model.StateEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.rum.model.StateEnum.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rum.model.primitives
              .TagKey(key) -> zio.aws.rum.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.AppMonitor
  ): zio.aws.rum.model.AppMonitor.ReadOnly = new Wrapper(impl)
}
