package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppMonitorDetails(
    id: Optional[String] = Optional.Absent,
    name: Optional[String] = Optional.Absent,
    version: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.AppMonitorDetails = {
    import AppMonitorDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.AppMonitorDetails
      .builder()
      .optionallyWith(id.map(value => value: java.lang.String))(_.id)
      .optionallyWith(name.map(value => value: java.lang.String))(_.name)
      .optionallyWith(version.map(value => value: java.lang.String))(_.version)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.AppMonitorDetails.ReadOnly =
    zio.aws.rum.model.AppMonitorDetails.wrap(buildAwsValue())
}
object AppMonitorDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.AppMonitorDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.AppMonitorDetails =
      zio.aws.rum.model.AppMonitorDetails(
        id.map(value => value),
        name.map(value => value),
        version.map(value => value)
      )
    def id: Optional[String]
    def name: Optional[String]
    def version: Optional[String]
    def getId: ZIO[Any, AwsError, String] = AwsError.unwrapOptionField("id", id)
    def getName: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("name", name)
    def getVersion: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("version", version)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorDetails
  ) extends zio.aws.rum.model.AppMonitorDetails.ReadOnly {
    override val id: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => value: String)
    override val name: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => value: String)
    override val version: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.version())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorDetails
  ): zio.aws.rum.model.AppMonitorDetails.ReadOnly = new Wrapper(impl)
}
