package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.rum.model.primitives.AppMonitorName
import scala.jdk.CollectionConverters._
final case class DeleteAppMonitorRequest(name: AppMonitorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest = {
    import DeleteAppMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest
      .builder()
      .name(AppMonitorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.DeleteAppMonitorRequest.ReadOnly =
    zio.aws.rum.model.DeleteAppMonitorRequest.wrap(buildAwsValue())
}
object DeleteAppMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.DeleteAppMonitorRequest =
      zio.aws.rum.model.DeleteAppMonitorRequest(name)
    def name: AppMonitorName
    def getName: ZIO[Any, Nothing, AppMonitorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest
  ) extends zio.aws.rum.model.DeleteAppMonitorRequest.ReadOnly {
    override val name: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.DeleteAppMonitorRequest
  ): zio.aws.rum.model.DeleteAppMonitorRequest.ReadOnly = new Wrapper(impl)
}
