package zio.aws.rum.model
import zio.aws.rum.model.primitives.{Token, AppMonitorName, MaxQueryResults}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetAppMonitorDataRequest(
    filters: Optional[Iterable[zio.aws.rum.model.QueryFilter]] =
      Optional.Absent,
    maxResults: Optional[MaxQueryResults] = Optional.Absent,
    name: AppMonitorName,
    nextToken: Optional[Token] = Optional.Absent,
    timeRange: zio.aws.rum.model.TimeRange
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest = {
    import GetAppMonitorDataRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest
      .builder()
      .optionallyWith(
        filters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.filters)
      .optionallyWith(
        maxResults.map(value => MaxQueryResults.unwrap(value): Integer)
      )(_.maxResults)
      .name(AppMonitorName.unwrap(name): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .timeRange(timeRange.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.rum.model.GetAppMonitorDataRequest.ReadOnly =
    zio.aws.rum.model.GetAppMonitorDataRequest.wrap(buildAwsValue())
}
object GetAppMonitorDataRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.GetAppMonitorDataRequest =
      zio.aws.rum.model.GetAppMonitorDataRequest(
        filters.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        name,
        nextToken.map(value => value),
        timeRange.asEditable
      )
    def filters: Optional[List[zio.aws.rum.model.QueryFilter.ReadOnly]]
    def maxResults: Optional[MaxQueryResults]
    def name: AppMonitorName
    def nextToken: Optional[Token]
    def timeRange: zio.aws.rum.model.TimeRange.ReadOnly
    def getFilters
        : ZIO[Any, AwsError, List[zio.aws.rum.model.QueryFilter.ReadOnly]] =
      AwsError.unwrapOptionField("filters", filters)
    def getMaxResults: ZIO[Any, AwsError, MaxQueryResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getName: ZIO[Any, Nothing, AppMonitorName] = ZIO.succeed(name)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getTimeRange: ZIO[Any, Nothing, zio.aws.rum.model.TimeRange.ReadOnly] =
      ZIO.succeed(timeRange)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest
  ) extends zio.aws.rum.model.GetAppMonitorDataRequest.ReadOnly {
    override val filters
        : Optional[List[zio.aws.rum.model.QueryFilter.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.filters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.QueryFilter.wrap(item)
          }.toList
        )
    override val maxResults: Optional[MaxQueryResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rum.model.primitives.MaxQueryResults(value))
    override val name: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.name())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rum.model.primitives.Token(value))
    override val timeRange: zio.aws.rum.model.TimeRange.ReadOnly =
      zio.aws.rum.model.TimeRange.wrap(impl.timeRange())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorDataRequest
  ): zio.aws.rum.model.GetAppMonitorDataRequest.ReadOnly = new Wrapper(impl)
}
