package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.Integer
import scala.jdk.CollectionConverters._
final case class ListAppMonitorsRequest(
    maxResults: Optional[Integer] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest = {
    import ListAppMonitorsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest
      .builder()
      .optionallyWith(maxResults.map(value => value: java.lang.Integer))(
        _.maxResults
      )
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.ListAppMonitorsRequest.ReadOnly =
    zio.aws.rum.model.ListAppMonitorsRequest.wrap(buildAwsValue())
}
object ListAppMonitorsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.ListAppMonitorsRequest =
      zio.aws.rum.model.ListAppMonitorsRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[Integer]
    def nextToken: Optional[String]
    def getMaxResults: ZIO[Any, AwsError, Integer] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest
  ) extends zio.aws.rum.model.ListAppMonitorsRequest.ReadOnly {
    override val maxResults: Optional[Integer] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => value: Integer)
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.ListAppMonitorsRequest
  ): zio.aws.rum.model.ListAppMonitorsRequest.ReadOnly = new Wrapper(impl)
}
