package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.rum.model.primitives.AppMonitorId
import scala.jdk.CollectionConverters._
final case class PutRumEventsRequest(
    appMonitorDetails: zio.aws.rum.model.AppMonitorDetails,
    batchId: String,
    id: AppMonitorId,
    rumEvents: Iterable[zio.aws.rum.model.RumEvent],
    userDetails: zio.aws.rum.model.UserDetails
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.PutRumEventsRequest = {
    import PutRumEventsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.PutRumEventsRequest
      .builder()
      .appMonitorDetails(appMonitorDetails.buildAwsValue())
      .batchId(batchId: java.lang.String)
      .id(AppMonitorId.unwrap(id): java.lang.String)
      .rumEvents(rumEvents.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .userDetails(userDetails.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.rum.model.PutRumEventsRequest.ReadOnly =
    zio.aws.rum.model.PutRumEventsRequest.wrap(buildAwsValue())
}
object PutRumEventsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.PutRumEventsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.PutRumEventsRequest =
      zio.aws.rum.model.PutRumEventsRequest(
        appMonitorDetails.asEditable,
        batchId,
        id,
        rumEvents.map { item =>
          item.asEditable
        },
        userDetails.asEditable
      )
    def appMonitorDetails: zio.aws.rum.model.AppMonitorDetails.ReadOnly
    def batchId: String
    def id: AppMonitorId
    def rumEvents: List[zio.aws.rum.model.RumEvent.ReadOnly]
    def userDetails: zio.aws.rum.model.UserDetails.ReadOnly
    def getAppMonitorDetails
        : ZIO[Any, Nothing, zio.aws.rum.model.AppMonitorDetails.ReadOnly] =
      ZIO.succeed(appMonitorDetails)
    def getBatchId: ZIO[Any, Nothing, String] = ZIO.succeed(batchId)
    def getId: ZIO[Any, Nothing, AppMonitorId] = ZIO.succeed(id)
    def getRumEvents
        : ZIO[Any, Nothing, List[zio.aws.rum.model.RumEvent.ReadOnly]] =
      ZIO.succeed(rumEvents)
    def getUserDetails
        : ZIO[Any, Nothing, zio.aws.rum.model.UserDetails.ReadOnly] =
      ZIO.succeed(userDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.PutRumEventsRequest
  ) extends zio.aws.rum.model.PutRumEventsRequest.ReadOnly {
    override val appMonitorDetails
        : zio.aws.rum.model.AppMonitorDetails.ReadOnly =
      zio.aws.rum.model.AppMonitorDetails.wrap(impl.appMonitorDetails())
    override val batchId: String = impl.batchId(): String
    override val id: AppMonitorId =
      zio.aws.rum.model.primitives.AppMonitorId(impl.id())
    override val rumEvents: List[zio.aws.rum.model.RumEvent.ReadOnly] = impl
      .rumEvents()
      .asScala
      .map { item =>
        zio.aws.rum.model.RumEvent.wrap(item)
      }
      .toList
    override val userDetails: zio.aws.rum.model.UserDetails.ReadOnly =
      zio.aws.rum.model.UserDetails.wrap(impl.userDetails())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.PutRumEventsRequest
  ): zio.aws.rum.model.PutRumEventsRequest.ReadOnly = new Wrapper(impl)
}
