package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{QueryFilterValue, QueryFilterKey}
import scala.jdk.CollectionConverters._
final case class QueryFilter(
    name: Optional[QueryFilterKey] = Optional.Absent,
    values: Optional[Iterable[QueryFilterValue]] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.QueryFilter = {
    import QueryFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.QueryFilter
      .builder()
      .optionallyWith(
        name.map(value => QueryFilterKey.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            QueryFilterValue.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.QueryFilter.ReadOnly =
    zio.aws.rum.model.QueryFilter.wrap(buildAwsValue())
}
object QueryFilter {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.QueryFilter] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.QueryFilter = zio.aws.rum.model
      .QueryFilter(name.map(value => value), values.map(value => value))
    def name: Optional[QueryFilterKey]
    def values: Optional[List[QueryFilterValue]]
    def getName: ZIO[Any, AwsError, QueryFilterKey] =
      AwsError.unwrapOptionField("name", name)
    def getValues: ZIO[Any, AwsError, List[QueryFilterValue]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.QueryFilter
  ) extends zio.aws.rum.model.QueryFilter.ReadOnly {
    override val name: Optional[QueryFilterKey] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.rum.model.primitives.QueryFilterKey(value))
    override val values: Optional[List[QueryFilterValue]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.values())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.primitives.QueryFilterValue(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.QueryFilter
  ): zio.aws.rum.model.QueryFilter.ReadOnly = new Wrapper(impl)
}
