package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.rum.model.primitives.{TagValue, TagKey, Arn}
import scala.jdk.CollectionConverters._
final case class TagResourceRequest(
    resourceArn: Arn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.TagResourceRequest
      .builder()
      .resourceArn(Arn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.TagResourceRequest.ReadOnly =
    zio.aws.rum.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.TagResourceRequest =
      zio.aws.rum.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: Arn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.TagResourceRequest
  ) extends zio.aws.rum.model.TagResourceRequest.ReadOnly {
    override val resourceArn: Arn =
      zio.aws.rum.model.primitives.Arn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.rum.model.primitives.TagKey(key) -> zio.aws.rum.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.TagResourceRequest
  ): zio.aws.rum.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
