package zio.aws.rum.model
import scala.jdk.CollectionConverters._
sealed trait Telemetry {
  def unwrap: software.amazon.awssdk.services.rum.model.Telemetry
}
object Telemetry {
  def wrap(
      value: software.amazon.awssdk.services.rum.model.Telemetry
  ): zio.aws.rum.model.Telemetry = value match {
    case software.amazon.awssdk.services.rum.model.Telemetry.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rum.model.Telemetry.ERRORS =>
      val r = errors
      r
    case software.amazon.awssdk.services.rum.model.Telemetry.PERFORMANCE =>
      val r = performance
      r
    case software.amazon.awssdk.services.rum.model.Telemetry.HTTP =>
      val r = http
      r
  }
  case object unknownToSdkVersion extends zio.aws.rum.model.Telemetry {
    override def unwrap: software.amazon.awssdk.services.rum.model.Telemetry =
      software.amazon.awssdk.services.rum.model.Telemetry.UNKNOWN_TO_SDK_VERSION
  }
  case object errors extends zio.aws.rum.model.Telemetry {
    override def unwrap: software.amazon.awssdk.services.rum.model.Telemetry =
      software.amazon.awssdk.services.rum.model.Telemetry.ERRORS
  }
  case object performance extends zio.aws.rum.model.Telemetry {
    override def unwrap: software.amazon.awssdk.services.rum.model.Telemetry =
      software.amazon.awssdk.services.rum.model.Telemetry.PERFORMANCE
  }
  case object http extends zio.aws.rum.model.Telemetry {
    override def unwrap: software.amazon.awssdk.services.rum.model.Telemetry =
      software.amazon.awssdk.services.rum.model.Telemetry.HTTP
  }
}
