package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class UserDetails(
    sessionId: Optional[String] = Optional.Absent,
    userId: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.UserDetails = {
    import UserDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.UserDetails
      .builder()
      .optionallyWith(sessionId.map(value => value: java.lang.String))(
        _.sessionId
      )
      .optionallyWith(userId.map(value => value: java.lang.String))(_.userId)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.UserDetails.ReadOnly =
    zio.aws.rum.model.UserDetails.wrap(buildAwsValue())
}
object UserDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.UserDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.UserDetails = zio.aws.rum.model
      .UserDetails(sessionId.map(value => value), userId.map(value => value))
    def sessionId: Optional[String]
    def userId: Optional[String]
    def getSessionId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("sessionId", sessionId)
    def getUserId: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("userId", userId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.UserDetails
  ) extends zio.aws.rum.model.UserDetails.ReadOnly {
    override val sessionId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.sessionId())
      .map(value => value: String)
    override val userId: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.userId())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.UserDetails
  ): zio.aws.rum.model.UserDetails.ReadOnly = new Wrapper(impl)
}
