package zio.aws.rum
import zio.prelude.Subtype
import java.time.Instant
import zio.aws.rum.model.primitives.{
  EventData,
  Url,
  TagValue,
  QueryFilterValue,
  TagKey
}
import zio.aws.rum.model.primitives.IdentityPoolId.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object AppMonitorDomain extends Subtype[String]
    type AppMonitorDomain = zio.aws.rum.model.primitives.AppMonitorDomain.Type
    object AppMonitorId extends Subtype[String]
    type AppMonitorId = zio.aws.rum.model.primitives.AppMonitorId.Type
    object AppMonitorName extends Subtype[String]
    type AppMonitorName = zio.aws.rum.model.primitives.AppMonitorName.Type
    object Arn extends Subtype[String]
    type Arn = zio.aws.rum.model.primitives.Arn.Type
    object EventData extends Subtype[String]
    type EventData = zio.aws.rum.model.primitives.EventData.Type
    object ISOTimestampString extends Subtype[String]
    type ISOTimestampString =
      zio.aws.rum.model.primitives.ISOTimestampString.Type
    object IdentityPoolId extends Subtype[String]
    type IdentityPoolId = zio.aws.rum.model.primitives.IdentityPoolId.Type
    type Integer = Int
    object JsonValue extends Subtype[String]
    type JsonValue = zio.aws.rum.model.primitives.JsonValue.Type
    object MaxQueryResults extends Subtype[Int]
    type MaxQueryResults = zio.aws.rum.model.primitives.MaxQueryResults.Type
    object QueryFilterKey extends Subtype[String]
    type QueryFilterKey = zio.aws.rum.model.primitives.QueryFilterKey.Type
    object QueryFilterValue extends Subtype[String]
    type QueryFilterValue = zio.aws.rum.model.primitives.QueryFilterValue.Type
    object QueryTimestamp extends Subtype[Long]
    type QueryTimestamp = zio.aws.rum.model.primitives.QueryTimestamp.Type
    object SessionSampleRate extends Subtype[Double]
    type SessionSampleRate = zio.aws.rum.model.primitives.SessionSampleRate.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.rum.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.rum.model.primitives.TagValue.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.rum.model.primitives.Timestamp.Type
    object Token extends Subtype[String]
    type Token = zio.aws.rum.model.primitives.Token.Type
    object Url extends Subtype[String]
    type Url = zio.aws.rum.model.primitives.Url.Type
  }
  type AppMonitorSummaryList = List[zio.aws.rum.model.AppMonitorSummary]
  type EventDataList = List[EventData]
  type FavoritePages = List[String]
  type Pages = List[Url]
  type QueryFilterValueList = List[QueryFilterValue]
  type QueryFilters = List[zio.aws.rum.model.QueryFilter]
  type RumEventList = List[zio.aws.rum.model.RumEvent]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type Telemetries = List[zio.aws.rum.model.Telemetry]
}
