package zio.aws.rum
import zio.aws.rum.model.MetricDestinationSummary.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.rum.model.primitives.EventData
import zio.aws.rum.model.{
  GetAppMonitorDataRequest,
  BatchCreateRumMetricDefinitionsRequest,
  ListTagsForResourceRequest,
  PutRumMetricsDestinationRequest,
  DeleteRumMetricsDestinationRequest,
  ListRumMetricsDestinationsRequest,
  ListAppMonitorsRequest,
  BatchGetRumMetricDefinitionsRequest,
  UntagResourceRequest,
  CreateAppMonitorRequest,
  UpdateAppMonitorRequest,
  DeleteAppMonitorRequest,
  UpdateRumMetricDefinitionRequest,
  BatchDeleteRumMetricDefinitionsRequest,
  PutRumEventsRequest,
  TagResourceRequest,
  GetAppMonitorRequest
}
import software.amazon.awssdk.services.rum.RumAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object RumMock extends Mock[Rum] {
  object DeleteAppMonitor
      extends Effect[
        DeleteAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly
      ]
  object BatchDeleteRumMetricDefinitions
      extends Effect[
        BatchDeleteRumMetricDefinitionsRequest,
        AwsError,
        zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse.ReadOnly
      ]
  object PutRumEvents
      extends Effect[
        PutRumEventsRequest,
        AwsError,
        zio.aws.rum.model.PutRumEventsResponse.ReadOnly
      ]
  object PutRumMetricsDestination
      extends Effect[
        PutRumMetricsDestinationRequest,
        AwsError,
        zio.aws.rum.model.PutRumMetricsDestinationResponse.ReadOnly
      ]
  object DeleteRumMetricsDestination
      extends Effect[
        DeleteRumMetricsDestinationRequest,
        AwsError,
        zio.aws.rum.model.DeleteRumMetricsDestinationResponse.ReadOnly
      ]
  object BatchCreateRumMetricDefinitions
      extends Effect[
        BatchCreateRumMetricDefinitionsRequest,
        AwsError,
        zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse.ReadOnly
      ]
  object ListAppMonitors
      extends Stream[
        ListAppMonitorsRequest,
        AwsError,
        zio.aws.rum.model.AppMonitorSummary.ReadOnly
      ]
  object ListAppMonitorsPaginated
      extends Effect[
        ListAppMonitorsRequest,
        AwsError,
        zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.rum.model.UntagResourceResponse.ReadOnly
      ]
  object BatchGetRumMetricDefinitions
      extends Stream[
        BatchGetRumMetricDefinitionsRequest,
        AwsError,
        zio.aws.rum.model.MetricDefinition.ReadOnly
      ]
  object BatchGetRumMetricDefinitionsPaginated
      extends Effect[
        BatchGetRumMetricDefinitionsRequest,
        AwsError,
        zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly
      ]
  object GetAppMonitorData
      extends Stream[GetAppMonitorDataRequest, AwsError, EventData]
  object GetAppMonitorDataPaginated
      extends Effect[
        GetAppMonitorDataRequest,
        AwsError,
        zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.rum.model.TagResourceResponse.ReadOnly
      ]
  object ListRumMetricsDestinations
      extends Stream[ListRumMetricsDestinationsRequest, AwsError, ReadOnly]
  object ListRumMetricsDestinationsPaginated
      extends Effect[
        ListRumMetricsDestinationsRequest,
        AwsError,
        zio.aws.rum.model.ListRumMetricsDestinationsResponse.ReadOnly
      ]
  object UpdateAppMonitor
      extends Effect[
        UpdateAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly
      ]
  object GetAppMonitor
      extends Effect[
        GetAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.GetAppMonitorResponse.ReadOnly
      ]
  object CreateAppMonitor
      extends Effect[
        CreateAppMonitorRequest,
        AwsError,
        zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly
      ]
  object UpdateRumMetricDefinition
      extends Effect[
        UpdateRumMetricDefinitionRequest,
        AwsError,
        zio.aws.rum.model.UpdateRumMetricDefinitionResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Rum] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Rum] { rts =>
        zio.ZIO.succeed {
          new Rum {
            val api: RumAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Rum = this
            def deleteAppMonitor(request: DeleteAppMonitorRequest): IO[
              AwsError,
              zio.aws.rum.model.DeleteAppMonitorResponse.ReadOnly
            ] = proxy(DeleteAppMonitor, request)
            def batchDeleteRumMetricDefinitions(
                request: BatchDeleteRumMetricDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse.ReadOnly
            ] = proxy(BatchDeleteRumMetricDefinitions, request)
            def putRumEvents(
                request: PutRumEventsRequest
            ): IO[AwsError, zio.aws.rum.model.PutRumEventsResponse.ReadOnly] =
              proxy(PutRumEvents, request)
            def putRumMetricsDestination(
                request: PutRumMetricsDestinationRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.PutRumMetricsDestinationResponse.ReadOnly
            ] = proxy(PutRumMetricsDestination, request)
            def deleteRumMetricsDestination(
                request: DeleteRumMetricsDestinationRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.DeleteRumMetricsDestinationResponse.ReadOnly
            ] = proxy(DeleteRumMetricsDestination, request)
            def batchCreateRumMetricDefinitions(
                request: BatchCreateRumMetricDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse.ReadOnly
            ] = proxy(BatchCreateRumMetricDefinitions, request)
            def listAppMonitors(request: ListAppMonitorsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.rum.model.AppMonitorSummary.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListAppMonitors, request)
                }
                .getOrThrowFiberFailure()
            }
            def listAppMonitorsPaginated(request: ListAppMonitorsRequest): IO[
              AwsError,
              zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly
            ] = proxy(ListAppMonitorsPaginated, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.rum.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def batchGetRumMetricDefinitions(
                request: BatchGetRumMetricDefinitionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.rum.model.MetricDefinition.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(BatchGetRumMetricDefinitions, request)
                }
                .getOrThrowFiberFailure()
            }
            def batchGetRumMetricDefinitionsPaginated(
                request: BatchGetRumMetricDefinitionsRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.ReadOnly
            ] = proxy(BatchGetRumMetricDefinitionsPaginated, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.rum.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def getAppMonitorData(
                request: GetAppMonitorDataRequest
            ): ZStream[Any, AwsError, EventData] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetAppMonitorData, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getAppMonitorDataPaginated(
                request: GetAppMonitorDataRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly
            ] = proxy(GetAppMonitorDataPaginated, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.rum.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def listRumMetricsDestinations(
                request: ListRumMetricsDestinationsRequest
            ): ZStream[Any, AwsError, ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(ListRumMetricsDestinations, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def listRumMetricsDestinationsPaginated(
                request: ListRumMetricsDestinationsRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.ListRumMetricsDestinationsResponse.ReadOnly
            ] = proxy(ListRumMetricsDestinationsPaginated, request)
            def updateAppMonitor(request: UpdateAppMonitorRequest): IO[
              AwsError,
              zio.aws.rum.model.UpdateAppMonitorResponse.ReadOnly
            ] = proxy(UpdateAppMonitor, request)
            def getAppMonitor(
                request: GetAppMonitorRequest
            ): IO[AwsError, zio.aws.rum.model.GetAppMonitorResponse.ReadOnly] =
              proxy(GetAppMonitor, request)
            def createAppMonitor(request: CreateAppMonitorRequest): IO[
              AwsError,
              zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly
            ] = proxy(CreateAppMonitor, request)
            def updateRumMetricDefinition(
                request: UpdateRumMetricDefinitionRequest
            ): IO[
              AwsError,
              zio.aws.rum.model.UpdateRumMetricDefinitionResponse.ReadOnly
            ] = proxy(UpdateRumMetricDefinition, request)
          }
        }
      }
    }
  }
}
