package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  SessionSampleRate,
  IdentityPoolId,
  Arn,
  Url
}
import scala.jdk.CollectionConverters._
final case class AppMonitorConfiguration(
    allowCookies: Optional[Boolean] = Optional.Absent,
    enableXRay: Optional[Boolean] = Optional.Absent,
    excludedPages: Optional[Iterable[Url]] = Optional.Absent,
    favoritePages: Optional[Iterable[String]] = Optional.Absent,
    guestRoleArn: Optional[Arn] = Optional.Absent,
    identityPoolId: Optional[IdentityPoolId] = Optional.Absent,
    includedPages: Optional[Iterable[Url]] = Optional.Absent,
    sessionSampleRate: Optional[SessionSampleRate] = Optional.Absent,
    telemetries: Optional[Iterable[zio.aws.rum.model.Telemetry]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.AppMonitorConfiguration = {
    import AppMonitorConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.AppMonitorConfiguration
      .builder()
      .optionallyWith(allowCookies.map(value => value: java.lang.Boolean))(
        _.allowCookies
      )
      .optionallyWith(enableXRay.map(value => value: java.lang.Boolean))(
        _.enableXRay
      )
      .optionallyWith(
        excludedPages.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.excludedPages)
      .optionallyWith(
        favoritePages.map(value =>
          value.map { item =>
            item: java.lang.String
          }.asJavaCollection
        )
      )(_.favoritePages)
      .optionallyWith(
        guestRoleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.guestRoleArn)
      .optionallyWith(
        identityPoolId.map(value =>
          IdentityPoolId.unwrap(value): java.lang.String
        )
      )(_.identityPoolId)
      .optionallyWith(
        includedPages.map(value =>
          value.map { item =>
            Url.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.includedPages)
      .optionallyWith(
        sessionSampleRate.map(value =>
          SessionSampleRate.unwrap(value): java.lang.Double
        )
      )(_.sessionSampleRate)
      .optionallyWith(
        telemetries.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.telemetriesWithStrings)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.AppMonitorConfiguration.ReadOnly =
    zio.aws.rum.model.AppMonitorConfiguration.wrap(buildAwsValue())
}
object AppMonitorConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.AppMonitorConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.AppMonitorConfiguration =
      zio.aws.rum.model.AppMonitorConfiguration(
        allowCookies.map(value => value),
        enableXRay.map(value => value),
        excludedPages.map(value => value),
        favoritePages.map(value => value),
        guestRoleArn.map(value => value),
        identityPoolId.map(value => value),
        includedPages.map(value => value),
        sessionSampleRate.map(value => value),
        telemetries.map(value => value)
      )
    def allowCookies: Optional[Boolean]
    def enableXRay: Optional[Boolean]
    def excludedPages: Optional[List[Url]]
    def favoritePages: Optional[List[String]]
    def guestRoleArn: Optional[Arn]
    def identityPoolId: Optional[IdentityPoolId]
    def includedPages: Optional[List[Url]]
    def sessionSampleRate: Optional[SessionSampleRate]
    def telemetries: Optional[List[zio.aws.rum.model.Telemetry]]
    def getAllowCookies: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("allowCookies", allowCookies)
    def getEnableXRay: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("enableXRay", enableXRay)
    def getExcludedPages: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("excludedPages", excludedPages)
    def getFavoritePages: ZIO[Any, AwsError, List[String]] =
      AwsError.unwrapOptionField("favoritePages", favoritePages)
    def getGuestRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("guestRoleArn", guestRoleArn)
    def getIdentityPoolId: ZIO[Any, AwsError, IdentityPoolId] =
      AwsError.unwrapOptionField("identityPoolId", identityPoolId)
    def getIncludedPages: ZIO[Any, AwsError, List[Url]] =
      AwsError.unwrapOptionField("includedPages", includedPages)
    def getSessionSampleRate: ZIO[Any, AwsError, SessionSampleRate] =
      AwsError.unwrapOptionField("sessionSampleRate", sessionSampleRate)
    def getTelemetries: ZIO[Any, AwsError, List[zio.aws.rum.model.Telemetry]] =
      AwsError.unwrapOptionField("telemetries", telemetries)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorConfiguration
  ) extends zio.aws.rum.model.AppMonitorConfiguration.ReadOnly {
    override val allowCookies: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.allowCookies())
      .map(value => value: Boolean)
    override val enableXRay: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.enableXRay())
      .map(value => value: Boolean)
    override val excludedPages: Optional[List[Url]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludedPages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rum.model.primitives.Url(item)
        }.toList
      )
    override val favoritePages: Optional[List[String]] = zio.aws.core.internal
      .optionalFromNullable(impl.favoritePages())
      .map(value =>
        value.asScala.map { item =>
          item: String
        }.toList
      )
    override val guestRoleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.guestRoleArn())
      .map(value => zio.aws.rum.model.primitives.Arn(value))
    override val identityPoolId: Optional[IdentityPoolId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.identityPoolId())
        .map(value => zio.aws.rum.model.primitives.IdentityPoolId(value))
    override val includedPages: Optional[List[Url]] = zio.aws.core.internal
      .optionalFromNullable(impl.includedPages())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rum.model.primitives.Url(item)
        }.toList
      )
    override val sessionSampleRate: Optional[SessionSampleRate] =
      zio.aws.core.internal
        .optionalFromNullable(impl.sessionSampleRate())
        .map(value => zio.aws.rum.model.primitives.SessionSampleRate(value))
    override val telemetries: Optional[List[zio.aws.rum.model.Telemetry]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.telemetries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.Telemetry.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorConfiguration
  ): zio.aws.rum.model.AppMonitorConfiguration.ReadOnly = new Wrapper(impl)
}
