package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  AppMonitorName,
  AppMonitorId,
  ISOTimestampString
}
import scala.jdk.CollectionConverters._
final case class AppMonitorSummary(
    created: Optional[ISOTimestampString] = Optional.Absent,
    id: Optional[AppMonitorId] = Optional.Absent,
    lastModified: Optional[ISOTimestampString] = Optional.Absent,
    name: Optional[AppMonitorName] = Optional.Absent,
    state: Optional[zio.aws.rum.model.StateEnum] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.AppMonitorSummary = {
    import AppMonitorSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.AppMonitorSummary
      .builder()
      .optionallyWith(
        created.map(value => ISOTimestampString.unwrap(value): java.lang.String)
      )(_.created)
      .optionallyWith(
        id.map(value => AppMonitorId.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        lastModified.map(value =>
          ISOTimestampString.unwrap(value): java.lang.String
        )
      )(_.lastModified)
      .optionallyWith(
        name.map(value => AppMonitorName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.AppMonitorSummary.ReadOnly =
    zio.aws.rum.model.AppMonitorSummary.wrap(buildAwsValue())
}
object AppMonitorSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.AppMonitorSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.AppMonitorSummary =
      zio.aws.rum.model.AppMonitorSummary(
        created.map(value => value),
        id.map(value => value),
        lastModified.map(value => value),
        name.map(value => value),
        state.map(value => value)
      )
    def created: Optional[ISOTimestampString]
    def id: Optional[AppMonitorId]
    def lastModified: Optional[ISOTimestampString]
    def name: Optional[AppMonitorName]
    def state: Optional[zio.aws.rum.model.StateEnum]
    def getCreated: ZIO[Any, AwsError, ISOTimestampString] =
      AwsError.unwrapOptionField("created", created)
    def getId: ZIO[Any, AwsError, AppMonitorId] =
      AwsError.unwrapOptionField("id", id)
    def getLastModified: ZIO[Any, AwsError, ISOTimestampString] =
      AwsError.unwrapOptionField("lastModified", lastModified)
    def getName: ZIO[Any, AwsError, AppMonitorName] =
      AwsError.unwrapOptionField("name", name)
    def getState: ZIO[Any, AwsError, zio.aws.rum.model.StateEnum] =
      AwsError.unwrapOptionField("state", state)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorSummary
  ) extends zio.aws.rum.model.AppMonitorSummary.ReadOnly {
    override val created: Optional[ISOTimestampString] = zio.aws.core.internal
      .optionalFromNullable(impl.created())
      .map(value => zio.aws.rum.model.primitives.ISOTimestampString(value))
    override val id: Optional[AppMonitorId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.rum.model.primitives.AppMonitorId(value))
    override val lastModified: Optional[ISOTimestampString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastModified())
        .map(value => zio.aws.rum.model.primitives.ISOTimestampString(value))
    override val name: Optional[AppMonitorName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.rum.model.primitives.AppMonitorName(value))
    override val state: Optional[zio.aws.rum.model.StateEnum] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.rum.model.StateEnum.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.AppMonitorSummary
  ): zio.aws.rum.model.AppMonitorSummary.ReadOnly = new Wrapper(impl)
}
