package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class BatchCreateRumMetricDefinitionsError(
    errorCode: String,
    errorMessage: String,
    metricDefinition: zio.aws.rum.model.MetricDefinitionRequest
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError = {
    import BatchCreateRumMetricDefinitionsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .metricDefinition(metricDefinition.buildAwsValue())
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly =
    zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.wrap(buildAwsValue())
}
object BatchCreateRumMetricDefinitionsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchCreateRumMetricDefinitionsError =
      zio.aws.rum.model.BatchCreateRumMetricDefinitionsError(
        errorCode,
        errorMessage,
        metricDefinition.asEditable
      )
    def errorCode: String
    def errorMessage: String
    def metricDefinition: zio.aws.rum.model.MetricDefinitionRequest.ReadOnly
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
    def getMetricDefinition: ZIO[
      Any,
      Nothing,
      zio.aws.rum.model.MetricDefinitionRequest.ReadOnly
    ] = ZIO.succeed(metricDefinition)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError
  ) extends zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: String = impl.errorMessage(): String
    override val metricDefinition
        : zio.aws.rum.model.MetricDefinitionRequest.ReadOnly =
      zio.aws.rum.model.MetricDefinitionRequest.wrap(impl.metricDefinition())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsError
  ): zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly =
    new Wrapper(impl)
}
