package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{DestinationArn, AppMonitorName}
import scala.jdk.CollectionConverters._
final case class BatchCreateRumMetricDefinitionsRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    metricDefinitions: Iterable[zio.aws.rum.model.MetricDefinitionRequest]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsRequest = {
    import BatchCreateRumMetricDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .metricDefinitions(metricDefinitions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest.ReadOnly =
    zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest
      .wrap(buildAwsValue())
}
object BatchCreateRumMetricDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest =
      zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value),
        metricDefinitions.map { item =>
          item.asEditable
        }
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def metricDefinitions
        : List[zio.aws.rum.model.MetricDefinitionRequest.ReadOnly]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getMetricDefinitions: ZIO[Any, Nothing, List[
      zio.aws.rum.model.MetricDefinitionRequest.ReadOnly
    ]] = ZIO.succeed(metricDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsRequest
  ) extends zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val metricDefinitions
        : List[zio.aws.rum.model.MetricDefinitionRequest.ReadOnly] = impl
      .metricDefinitions()
      .asScala
      .map { item =>
        zio.aws.rum.model.MetricDefinitionRequest.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsRequest
  ): zio.aws.rum.model.BatchCreateRumMetricDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
