package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchCreateRumMetricDefinitionsResponse(
    errors: Iterable[zio.aws.rum.model.BatchCreateRumMetricDefinitionsError],
    metricDefinitions: Optional[Iterable[zio.aws.rum.model.MetricDefinition]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsResponse = {
    import BatchCreateRumMetricDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse.ReadOnly =
    zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse
      .wrap(buildAwsValue())
}
object BatchCreateRumMetricDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse =
      zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse(
        errors.map { item =>
          item.asEditable
        },
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def errors
        : List[zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly]
    def metricDefinitions
        : Optional[List[zio.aws.rum.model.MetricDefinition.ReadOnly]]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.rum.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsResponse
  ) extends zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse.ReadOnly {
    override val errors: List[
      zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.rum.model.BatchCreateRumMetricDefinitionsError.wrap(item)
      }
      .toList
    override val metricDefinitions
        : Optional[List[zio.aws.rum.model.MetricDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.MetricDefinition.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchCreateRumMetricDefinitionsResponse
  ): zio.aws.rum.model.BatchCreateRumMetricDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
