package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.rum.model.primitives.MetricDefinitionId
import scala.jdk.CollectionConverters._
final case class BatchDeleteRumMetricDefinitionsError(
    errorCode: String,
    errorMessage: String,
    metricDefinitionId: MetricDefinitionId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError = {
    import BatchDeleteRumMetricDefinitionsError.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError
      .builder()
      .errorCode(errorCode: java.lang.String)
      .errorMessage(errorMessage: java.lang.String)
      .metricDefinitionId(
        MetricDefinitionId.unwrap(metricDefinitionId): java.lang.String
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly =
    zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.wrap(buildAwsValue())
}
object BatchDeleteRumMetricDefinitionsError {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError =
      zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError(
        errorCode,
        errorMessage,
        metricDefinitionId
      )
    def errorCode: String
    def errorMessage: String
    def metricDefinitionId: MetricDefinitionId
    def getErrorCode: ZIO[Any, Nothing, String] = ZIO.succeed(errorCode)
    def getErrorMessage: ZIO[Any, Nothing, String] = ZIO.succeed(errorMessage)
    def getMetricDefinitionId: ZIO[Any, Nothing, MetricDefinitionId] =
      ZIO.succeed(metricDefinitionId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError
  ) extends zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly {
    override val errorCode: String = impl.errorCode(): String
    override val errorMessage: String = impl.errorMessage(): String
    override val metricDefinitionId: MetricDefinitionId =
      zio.aws.rum.model.primitives.MetricDefinitionId(impl.metricDefinitionId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsError
  ): zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly =
    new Wrapper(impl)
}
