package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  MetricDefinitionId,
  DestinationArn,
  AppMonitorName
}
import scala.jdk.CollectionConverters._
final case class BatchDeleteRumMetricDefinitionsRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    metricDefinitionIds: Iterable[MetricDefinitionId]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsRequest = {
    import BatchDeleteRumMetricDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .metricDefinitionIds(metricDefinitionIds.map { item =>
        MetricDefinitionId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest.ReadOnly =
    zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest
      .wrap(buildAwsValue())
}
object BatchDeleteRumMetricDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest =
      zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value),
        metricDefinitionIds
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def metricDefinitionIds: List[MetricDefinitionId]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getMetricDefinitionIds: ZIO[Any, Nothing, List[MetricDefinitionId]] =
      ZIO.succeed(metricDefinitionIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsRequest
  ) extends zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val metricDefinitionIds: List[MetricDefinitionId] = impl
      .metricDefinitionIds()
      .asScala
      .map { item =>
        zio.aws.rum.model.primitives.MetricDefinitionId(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsRequest
  ): zio.aws.rum.model.BatchDeleteRumMetricDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
