package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.MetricDefinitionId
import scala.jdk.CollectionConverters._
final case class BatchDeleteRumMetricDefinitionsResponse(
    errors: Iterable[zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError],
    metricDefinitionIds: Optional[Iterable[MetricDefinitionId]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsResponse = {
    import BatchDeleteRumMetricDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsResponse
      .builder()
      .errors(errors.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        metricDefinitionIds.map(value =>
          value.map { item =>
            MetricDefinitionId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.metricDefinitionIds)
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse.ReadOnly =
    zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse
      .wrap(buildAwsValue())
}
object BatchDeleteRumMetricDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse =
      zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse(
        errors.map { item =>
          item.asEditable
        },
        metricDefinitionIds.map(value => value)
      )
    def errors
        : List[zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly]
    def metricDefinitionIds: Optional[List[MetricDefinitionId]]
    def getErrors: ZIO[Any, Nothing, List[
      zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly
    ]] = ZIO.succeed(errors)
    def getMetricDefinitionIds: ZIO[Any, AwsError, List[MetricDefinitionId]] =
      AwsError.unwrapOptionField("metricDefinitionIds", metricDefinitionIds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsResponse
  ) extends zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse.ReadOnly {
    override val errors: List[
      zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.ReadOnly
    ] = impl
      .errors()
      .asScala
      .map { item =>
        zio.aws.rum.model.BatchDeleteRumMetricDefinitionsError.wrap(item)
      }
      .toList
    override val metricDefinitionIds: Optional[List[MetricDefinitionId]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDefinitionIds())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.primitives.MetricDefinitionId(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchDeleteRumMetricDefinitionsResponse
  ): zio.aws.rum.model.BatchDeleteRumMetricDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
