package zio.aws.rum.model
import zio.aws.rum.model.primitives.{
  MaxResultsInteger,
  DestinationArn,
  AppMonitorName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class BatchGetRumMetricDefinitionsRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest = {
    import BatchGetRumMetricDefinitionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest.ReadOnly =
    zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest.wrap(buildAwsValue())
}
object BatchGetRumMetricDefinitionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest =
      zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def maxResults: Optional[MaxResultsInteger]
    def nextToken: Optional[String]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest
  ) extends zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rum.model.primitives.MaxResultsInteger(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsRequest
  ): zio.aws.rum.model.BatchGetRumMetricDefinitionsRequest.ReadOnly =
    new Wrapper(impl)
}
