package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class BatchGetRumMetricDefinitionsResponse(
    metricDefinitions: Optional[Iterable[zio.aws.rum.model.MetricDefinition]] =
      Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse = {
    import BatchGetRumMetricDefinitionsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse
      .builder()
      .optionallyWith(
        metricDefinitions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.metricDefinitions)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.ReadOnly =
    zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.wrap(buildAwsValue())
}
object BatchGetRumMetricDefinitionsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse =
      zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse(
        metricDefinitions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def metricDefinitions
        : Optional[List[zio.aws.rum.model.MetricDefinition.ReadOnly]]
    def nextToken: Optional[String]
    def getMetricDefinitions: ZIO[Any, AwsError, List[
      zio.aws.rum.model.MetricDefinition.ReadOnly
    ]] = AwsError.unwrapOptionField("metricDefinitions", metricDefinitions)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse
  ) extends zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.ReadOnly {
    override val metricDefinitions
        : Optional[List[zio.aws.rum.model.MetricDefinition.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.metricDefinitions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.MetricDefinition.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.BatchGetRumMetricDefinitionsResponse
  ): zio.aws.rum.model.BatchGetRumMetricDefinitionsResponse.ReadOnly =
    new Wrapper(impl)
}
