package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  TagValue,
  TagKey,
  AppMonitorName,
  AppMonitorDomain
}
import scala.jdk.CollectionConverters._
final case class CreateAppMonitorRequest(
    appMonitorConfiguration: Optional[
      zio.aws.rum.model.AppMonitorConfiguration
    ] = Optional.Absent,
    customEvents: Optional[zio.aws.rum.model.CustomEvents] = Optional.Absent,
    cwLogEnabled: Optional[Boolean] = Optional.Absent,
    domain: AppMonitorDomain,
    name: AppMonitorName,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest = {
    import CreateAppMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest
      .builder()
      .optionallyWith(
        appMonitorConfiguration.map(value => value.buildAwsValue())
      )(_.appMonitorConfiguration)
      .optionallyWith(customEvents.map(value => value.buildAwsValue()))(
        _.customEvents
      )
      .optionallyWith(cwLogEnabled.map(value => value: java.lang.Boolean))(
        _.cwLogEnabled
      )
      .domain(AppMonitorDomain.unwrap(domain): java.lang.String)
      .name(AppMonitorName.unwrap(name): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.CreateAppMonitorRequest.ReadOnly =
    zio.aws.rum.model.CreateAppMonitorRequest.wrap(buildAwsValue())
}
object CreateAppMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.CreateAppMonitorRequest =
      zio.aws.rum.model.CreateAppMonitorRequest(
        appMonitorConfiguration.map(value => value.asEditable),
        customEvents.map(value => value.asEditable),
        cwLogEnabled.map(value => value),
        domain,
        name,
        tags.map(value => value)
      )
    def appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly]
    def customEvents: Optional[zio.aws.rum.model.CustomEvents.ReadOnly]
    def cwLogEnabled: Optional[Boolean]
    def domain: AppMonitorDomain
    def name: AppMonitorName
    def tags: Optional[Map[TagKey, TagValue]]
    def getAppMonitorConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.rum.model.AppMonitorConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "appMonitorConfiguration",
      appMonitorConfiguration
    )
    def getCustomEvents
        : ZIO[Any, AwsError, zio.aws.rum.model.CustomEvents.ReadOnly] =
      AwsError.unwrapOptionField("customEvents", customEvents)
    def getCwLogEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cwLogEnabled", cwLogEnabled)
    def getDomain: ZIO[Any, Nothing, AppMonitorDomain] = ZIO.succeed(domain)
    def getName: ZIO[Any, Nothing, AppMonitorName] = ZIO.succeed(name)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest
  ) extends zio.aws.rum.model.CreateAppMonitorRequest.ReadOnly {
    override val appMonitorConfiguration
        : Optional[zio.aws.rum.model.AppMonitorConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appMonitorConfiguration())
        .map(value => zio.aws.rum.model.AppMonitorConfiguration.wrap(value))
    override val customEvents
        : Optional[zio.aws.rum.model.CustomEvents.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customEvents())
        .map(value => zio.aws.rum.model.CustomEvents.wrap(value))
    override val cwLogEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cwLogEnabled())
      .map(value => value: Boolean)
    override val domain: AppMonitorDomain =
      zio.aws.rum.model.primitives.AppMonitorDomain(impl.domain())
    override val name: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.name())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.rum.model.primitives
              .TagKey(key) -> zio.aws.rum.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.CreateAppMonitorRequest
  ): zio.aws.rum.model.CreateAppMonitorRequest.ReadOnly = new Wrapper(impl)
}
