package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.AppMonitorId
import scala.jdk.CollectionConverters._
final case class CreateAppMonitorResponse(
    id: Optional[AppMonitorId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse = {
    import CreateAppMonitorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse
      .builder()
      .optionallyWith(
        id.map(value => AppMonitorId.unwrap(value): java.lang.String)
      )(_.id)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly =
    zio.aws.rum.model.CreateAppMonitorResponse.wrap(buildAwsValue())
}
object CreateAppMonitorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.CreateAppMonitorResponse =
      zio.aws.rum.model.CreateAppMonitorResponse(id.map(value => value))
    def id: Optional[AppMonitorId]
    def getId: ZIO[Any, AwsError, AppMonitorId] =
      AwsError.unwrapOptionField("id", id)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse
  ) extends zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly {
    override val id: Optional[AppMonitorId] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.rum.model.primitives.AppMonitorId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.CreateAppMonitorResponse
  ): zio.aws.rum.model.CreateAppMonitorResponse.ReadOnly = new Wrapper(impl)
}
