package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CustomEvents(
    status: Optional[zio.aws.rum.model.CustomEventsStatus] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.CustomEvents = {
    import CustomEvents.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.CustomEvents
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.CustomEvents.ReadOnly =
    zio.aws.rum.model.CustomEvents.wrap(buildAwsValue())
}
object CustomEvents {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.CustomEvents] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.CustomEvents =
      zio.aws.rum.model.CustomEvents(status.map(value => value))
    def status: Optional[zio.aws.rum.model.CustomEventsStatus]
    def getStatus: ZIO[Any, AwsError, zio.aws.rum.model.CustomEventsStatus] =
      AwsError.unwrapOptionField("status", status)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.CustomEvents
  ) extends zio.aws.rum.model.CustomEvents.ReadOnly {
    override val status: Optional[zio.aws.rum.model.CustomEventsStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.rum.model.CustomEventsStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.CustomEvents
  ): zio.aws.rum.model.CustomEvents.ReadOnly = new Wrapper(impl)
}
