package zio.aws.rum.model
import scala.jdk.CollectionConverters._
sealed trait CustomEventsStatus {
  def unwrap: software.amazon.awssdk.services.rum.model.CustomEventsStatus
}
object CustomEventsStatus {
  def wrap(
      value: software.amazon.awssdk.services.rum.model.CustomEventsStatus
  ): zio.aws.rum.model.CustomEventsStatus = value match {
    case software.amazon.awssdk.services.rum.model.CustomEventsStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rum.model.CustomEventsStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.rum.model.CustomEventsStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.rum.model.CustomEventsStatus {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.CustomEventsStatus =
      software.amazon.awssdk.services.rum.model.CustomEventsStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.rum.model.CustomEventsStatus {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.CustomEventsStatus =
      software.amazon.awssdk.services.rum.model.CustomEventsStatus.ENABLED
  }
  case object DISABLED extends zio.aws.rum.model.CustomEventsStatus {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.CustomEventsStatus =
      software.amazon.awssdk.services.rum.model.CustomEventsStatus.DISABLED
  }
}
