package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CwLog(
    cwLogEnabled: Optional[Boolean] = Optional.Absent,
    cwLogGroup: Optional[String] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.CwLog = {
    import CwLog.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.CwLog
      .builder()
      .optionallyWith(cwLogEnabled.map(value => value: java.lang.Boolean))(
        _.cwLogEnabled
      )
      .optionallyWith(cwLogGroup.map(value => value: java.lang.String))(
        _.cwLogGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.CwLog.ReadOnly =
    zio.aws.rum.model.CwLog.wrap(buildAwsValue())
}
object CwLog {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.CwLog] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.CwLog = zio.aws.rum.model
      .CwLog(cwLogEnabled.map(value => value), cwLogGroup.map(value => value))
    def cwLogEnabled: Optional[Boolean]
    def cwLogGroup: Optional[String]
    def getCwLogEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("cwLogEnabled", cwLogEnabled)
    def getCwLogGroup: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("cwLogGroup", cwLogGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.CwLog
  ) extends zio.aws.rum.model.CwLog.ReadOnly {
    override val cwLogEnabled: Optional[Boolean] = zio.aws.core.internal
      .optionalFromNullable(impl.cwLogEnabled())
      .map(value => value: Boolean)
    override val cwLogGroup: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.cwLogGroup())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.CwLog
  ): zio.aws.rum.model.CwLog.ReadOnly = new Wrapper(impl)
}
