package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DataStorage(
    cwLog: Optional[zio.aws.rum.model.CwLog] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.DataStorage = {
    import DataStorage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.DataStorage
      .builder()
      .optionallyWith(cwLog.map(value => value.buildAwsValue()))(_.cwLog)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.DataStorage.ReadOnly =
    zio.aws.rum.model.DataStorage.wrap(buildAwsValue())
}
object DataStorage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.DataStorage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.DataStorage =
      zio.aws.rum.model.DataStorage(cwLog.map(value => value.asEditable))
    def cwLog: Optional[zio.aws.rum.model.CwLog.ReadOnly]
    def getCwLog: ZIO[Any, AwsError, zio.aws.rum.model.CwLog.ReadOnly] =
      AwsError.unwrapOptionField("cwLog", cwLog)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.DataStorage
  ) extends zio.aws.rum.model.DataStorage.ReadOnly {
    override val cwLog: Optional[zio.aws.rum.model.CwLog.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cwLog())
        .map(value => zio.aws.rum.model.CwLog.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.DataStorage
  ): zio.aws.rum.model.DataStorage.ReadOnly = new Wrapper(impl)
}
