package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{DestinationArn, AppMonitorName}
import scala.jdk.CollectionConverters._
final case class DeleteRumMetricsDestinationRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.DeleteRumMetricsDestinationRequest = {
    import DeleteRumMetricsDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.DeleteRumMetricsDestinationRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.DeleteRumMetricsDestinationRequest.ReadOnly =
    zio.aws.rum.model.DeleteRumMetricsDestinationRequest.wrap(buildAwsValue())
}
object DeleteRumMetricsDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.DeleteRumMetricsDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.DeleteRumMetricsDestinationRequest =
      zio.aws.rum.model.DeleteRumMetricsDestinationRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value)
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.DeleteRumMetricsDestinationRequest
  ) extends zio.aws.rum.model.DeleteRumMetricsDestinationRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.DeleteRumMetricsDestinationRequest
  ): zio.aws.rum.model.DeleteRumMetricsDestinationRequest.ReadOnly =
    new Wrapper(impl)
}
