package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{Token, EventData}
import scala.jdk.CollectionConverters._
final case class GetAppMonitorDataResponse(
    events: Optional[Iterable[EventData]] = Optional.Absent,
    nextToken: Optional[Token] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse = {
    import GetAppMonitorDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse
      .builder()
      .optionallyWith(
        events.map(value =>
          value.map { item =>
            EventData.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.events)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly =
    zio.aws.rum.model.GetAppMonitorDataResponse.wrap(buildAwsValue())
}
object GetAppMonitorDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.GetAppMonitorDataResponse =
      zio.aws.rum.model.GetAppMonitorDataResponse(
        events.map(value => value),
        nextToken.map(value => value)
      )
    def events: Optional[List[EventData]]
    def nextToken: Optional[Token]
    def getEvents: ZIO[Any, AwsError, List[EventData]] =
      AwsError.unwrapOptionField("events", events)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse
  ) extends zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly {
    override val events: Optional[List[EventData]] = zio.aws.core.internal
      .optionalFromNullable(impl.events())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.rum.model.primitives.EventData(item)
        }.toList
      )
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.rum.model.primitives.Token(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorDataResponse
  ): zio.aws.rum.model.GetAppMonitorDataResponse.ReadOnly = new Wrapper(impl)
}
