package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.rum.model.primitives.AppMonitorName
import scala.jdk.CollectionConverters._
final case class GetAppMonitorRequest(name: AppMonitorName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.GetAppMonitorRequest = {
    import GetAppMonitorRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.GetAppMonitorRequest
      .builder()
      .name(AppMonitorName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.GetAppMonitorRequest.ReadOnly =
    zio.aws.rum.model.GetAppMonitorRequest.wrap(buildAwsValue())
}
object GetAppMonitorRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.GetAppMonitorRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.GetAppMonitorRequest =
      zio.aws.rum.model.GetAppMonitorRequest(name)
    def name: AppMonitorName
    def getName: ZIO[Any, Nothing, AppMonitorName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorRequest
  ) extends zio.aws.rum.model.GetAppMonitorRequest.ReadOnly {
    override val name: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorRequest
  ): zio.aws.rum.model.GetAppMonitorRequest.ReadOnly = new Wrapper(impl)
}
