package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppMonitorResponse(
    appMonitor: Optional[zio.aws.rum.model.AppMonitor] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.GetAppMonitorResponse = {
    import GetAppMonitorResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.GetAppMonitorResponse
      .builder()
      .optionallyWith(appMonitor.map(value => value.buildAwsValue()))(
        _.appMonitor
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.GetAppMonitorResponse.ReadOnly =
    zio.aws.rum.model.GetAppMonitorResponse.wrap(buildAwsValue())
}
object GetAppMonitorResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.GetAppMonitorResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.GetAppMonitorResponse = zio.aws.rum.model
      .GetAppMonitorResponse(appMonitor.map(value => value.asEditable))
    def appMonitor: Optional[zio.aws.rum.model.AppMonitor.ReadOnly]
    def getAppMonitor
        : ZIO[Any, AwsError, zio.aws.rum.model.AppMonitor.ReadOnly] =
      AwsError.unwrapOptionField("appMonitor", appMonitor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorResponse
  ) extends zio.aws.rum.model.GetAppMonitorResponse.ReadOnly {
    override val appMonitor: Optional[zio.aws.rum.model.AppMonitor.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appMonitor())
        .map(value => zio.aws.rum.model.AppMonitor.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.GetAppMonitorResponse
  ): zio.aws.rum.model.GetAppMonitorResponse.ReadOnly = new Wrapper(impl)
}
