package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppMonitorsResponse(
    appMonitorSummaries: Optional[
      Iterable[zio.aws.rum.model.AppMonitorSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse = {
    import ListAppMonitorsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse
      .builder()
      .optionallyWith(
        appMonitorSummaries.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appMonitorSummaries)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly =
    zio.aws.rum.model.ListAppMonitorsResponse.wrap(buildAwsValue())
}
object ListAppMonitorsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.ListAppMonitorsResponse =
      zio.aws.rum.model.ListAppMonitorsResponse(
        appMonitorSummaries.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def appMonitorSummaries
        : Optional[List[zio.aws.rum.model.AppMonitorSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getAppMonitorSummaries: ZIO[Any, AwsError, List[
      zio.aws.rum.model.AppMonitorSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("appMonitorSummaries", appMonitorSummaries)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse
  ) extends zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly {
    override val appMonitorSummaries
        : Optional[List[zio.aws.rum.model.AppMonitorSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appMonitorSummaries())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.AppMonitorSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.ListAppMonitorsResponse
  ): zio.aws.rum.model.ListAppMonitorsResponse.ReadOnly = new Wrapper(impl)
}
