package zio.aws.rum.model
import zio.aws.rum.model.primitives.{MaxResultsInteger, AppMonitorName}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListRumMetricsDestinationsRequest(
    appMonitorName: AppMonitorName,
    maxResults: Optional[MaxResultsInteger] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest = {
    import ListRumMetricsDestinationsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .optionallyWith(
        maxResults.map(value => MaxResultsInteger.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly: zio.aws.rum.model.ListRumMetricsDestinationsRequest.ReadOnly =
    zio.aws.rum.model.ListRumMetricsDestinationsRequest.wrap(buildAwsValue())
}
object ListRumMetricsDestinationsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.ListRumMetricsDestinationsRequest =
      zio.aws.rum.model.ListRumMetricsDestinationsRequest(
        appMonitorName,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def appMonitorName: AppMonitorName
    def maxResults: Optional[MaxResultsInteger]
    def nextToken: Optional[String]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getMaxResults: ZIO[Any, AwsError, MaxResultsInteger] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest
  ) extends zio.aws.rum.model.ListRumMetricsDestinationsRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val maxResults: Optional[MaxResultsInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.rum.model.primitives.MaxResultsInteger(value))
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsRequest
  ): zio.aws.rum.model.ListRumMetricsDestinationsRequest.ReadOnly = new Wrapper(
    impl
  )
}
