package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListRumMetricsDestinationsResponse(
    destinations: Optional[
      Iterable[zio.aws.rum.model.MetricDestinationSummary]
    ] = Optional.Absent,
    nextToken: Optional[String] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse = {
    import ListRumMetricsDestinationsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse
      .builder()
      .optionallyWith(
        destinations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.destinations)
      .optionallyWith(nextToken.map(value => value: java.lang.String))(
        _.nextToken
      )
      .build()
  }
  def asReadOnly
      : zio.aws.rum.model.ListRumMetricsDestinationsResponse.ReadOnly =
    zio.aws.rum.model.ListRumMetricsDestinationsResponse.wrap(buildAwsValue())
}
object ListRumMetricsDestinationsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.ListRumMetricsDestinationsResponse =
      zio.aws.rum.model.ListRumMetricsDestinationsResponse(
        destinations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def destinations
        : Optional[List[zio.aws.rum.model.MetricDestinationSummary.ReadOnly]]
    def nextToken: Optional[String]
    def getDestinations: ZIO[Any, AwsError, List[
      zio.aws.rum.model.MetricDestinationSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("destinations", destinations)
    def getNextToken: ZIO[Any, AwsError, String] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse
  ) extends zio.aws.rum.model.ListRumMetricsDestinationsResponse.ReadOnly {
    override val destinations
        : Optional[List[zio.aws.rum.model.MetricDestinationSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.rum.model.MetricDestinationSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[String] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => value: String)
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.ListRumMetricsDestinationsResponse
  ): zio.aws.rum.model.ListRumMetricsDestinationsResponse.ReadOnly =
    new Wrapper(impl)
}
