package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{
  MetricName,
  ValueKey,
  Namespace,
  EventPattern,
  DimensionKey,
  UnitLabel,
  DimensionName
}
import scala.jdk.CollectionConverters._
final case class MetricDefinitionRequest(
    dimensionKeys: Optional[Map[DimensionKey, DimensionName]] = Optional.Absent,
    eventPattern: Optional[EventPattern] = Optional.Absent,
    name: MetricName,
    namespace: Optional[Namespace] = Optional.Absent,
    unitLabel: Optional[UnitLabel] = Optional.Absent,
    valueKey: Optional[ValueKey] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.MetricDefinitionRequest = {
    import MetricDefinitionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.MetricDefinitionRequest
      .builder()
      .optionallyWith(
        dimensionKeys.map(value =>
          value
            .map({ case (key, value) =>
              (DimensionKey.unwrap(key): java.lang.String) -> (DimensionName
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.dimensionKeys)
      .optionallyWith(
        eventPattern.map(value => EventPattern.unwrap(value): java.lang.String)
      )(_.eventPattern)
      .name(MetricName.unwrap(name): java.lang.String)
      .optionallyWith(
        namespace.map(value => Namespace.unwrap(value): java.lang.String)
      )(_.namespace)
      .optionallyWith(
        unitLabel.map(value => UnitLabel.unwrap(value): java.lang.String)
      )(_.unitLabel)
      .optionallyWith(
        valueKey.map(value => ValueKey.unwrap(value): java.lang.String)
      )(_.valueKey)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.MetricDefinitionRequest.ReadOnly =
    zio.aws.rum.model.MetricDefinitionRequest.wrap(buildAwsValue())
}
object MetricDefinitionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.MetricDefinitionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.MetricDefinitionRequest =
      zio.aws.rum.model.MetricDefinitionRequest(
        dimensionKeys.map(value => value),
        eventPattern.map(value => value),
        name,
        namespace.map(value => value),
        unitLabel.map(value => value),
        valueKey.map(value => value)
      )
    def dimensionKeys: Optional[Map[DimensionKey, DimensionName]]
    def eventPattern: Optional[EventPattern]
    def name: MetricName
    def namespace: Optional[Namespace]
    def unitLabel: Optional[UnitLabel]
    def valueKey: Optional[ValueKey]
    def getDimensionKeys: ZIO[Any, AwsError, Map[DimensionKey, DimensionName]] =
      AwsError.unwrapOptionField("dimensionKeys", dimensionKeys)
    def getEventPattern: ZIO[Any, AwsError, EventPattern] =
      AwsError.unwrapOptionField("eventPattern", eventPattern)
    def getName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(name)
    def getNamespace: ZIO[Any, AwsError, Namespace] =
      AwsError.unwrapOptionField("namespace", namespace)
    def getUnitLabel: ZIO[Any, AwsError, UnitLabel] =
      AwsError.unwrapOptionField("unitLabel", unitLabel)
    def getValueKey: ZIO[Any, AwsError, ValueKey] =
      AwsError.unwrapOptionField("valueKey", valueKey)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.MetricDefinitionRequest
  ) extends zio.aws.rum.model.MetricDefinitionRequest.ReadOnly {
    override val dimensionKeys: Optional[Map[DimensionKey, DimensionName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dimensionKeys())
        .map(value =>
          value.asScala
            .map({ case (key, value) =>
              zio.aws.rum.model.primitives.DimensionKey(
                key
              ) -> zio.aws.rum.model.primitives.DimensionName(value)
            })
            .toMap
        )
    override val eventPattern: Optional[EventPattern] = zio.aws.core.internal
      .optionalFromNullable(impl.eventPattern())
      .map(value => zio.aws.rum.model.primitives.EventPattern(value))
    override val name: MetricName =
      zio.aws.rum.model.primitives.MetricName(impl.name())
    override val namespace: Optional[Namespace] = zio.aws.core.internal
      .optionalFromNullable(impl.namespace())
      .map(value => zio.aws.rum.model.primitives.Namespace(value))
    override val unitLabel: Optional[UnitLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.unitLabel())
      .map(value => zio.aws.rum.model.primitives.UnitLabel(value))
    override val valueKey: Optional[ValueKey] = zio.aws.core.internal
      .optionalFromNullable(impl.valueKey())
      .map(value => zio.aws.rum.model.primitives.ValueKey(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.MetricDefinitionRequest
  ): zio.aws.rum.model.MetricDefinitionRequest.ReadOnly = new Wrapper(impl)
}
