package zio.aws.rum.model
import scala.jdk.CollectionConverters._
sealed trait MetricDestination {
  def unwrap: software.amazon.awssdk.services.rum.model.MetricDestination
}
object MetricDestination {
  def wrap(
      value: software.amazon.awssdk.services.rum.model.MetricDestination
  ): zio.aws.rum.model.MetricDestination = value match {
    case software.amazon.awssdk.services.rum.model.MetricDestination.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.rum.model.MetricDestination.CLOUD_WATCH =>
      val r = CloudWatch
      r
    case software.amazon.awssdk.services.rum.model.MetricDestination.EVIDENTLY =>
      val r = Evidently
      r
  }
  case object unknownToSdkVersion extends zio.aws.rum.model.MetricDestination {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.MetricDestination =
      software.amazon.awssdk.services.rum.model.MetricDestination.UNKNOWN_TO_SDK_VERSION
  }
  case object CloudWatch extends zio.aws.rum.model.MetricDestination {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.MetricDestination =
      software.amazon.awssdk.services.rum.model.MetricDestination.CLOUD_WATCH
  }
  case object Evidently extends zio.aws.rum.model.MetricDestination {
    override def unwrap
        : software.amazon.awssdk.services.rum.model.MetricDestination =
      software.amazon.awssdk.services.rum.model.MetricDestination.EVIDENTLY
  }
}
