package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{IamRoleArn, DestinationArn}
import scala.jdk.CollectionConverters._
final case class MetricDestinationSummary(
    destination: Optional[zio.aws.rum.model.MetricDestination] =
      Optional.Absent,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    iamRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.MetricDestinationSummary = {
    import MetricDestinationSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.MetricDestinationSummary
      .builder()
      .optionallyWith(destination.map(value => value.unwrap))(_.destination)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.MetricDestinationSummary.ReadOnly =
    zio.aws.rum.model.MetricDestinationSummary.wrap(buildAwsValue())
}
object MetricDestinationSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.MetricDestinationSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.MetricDestinationSummary =
      zio.aws.rum.model.MetricDestinationSummary(
        destination.map(value => value),
        destinationArn.map(value => value),
        iamRoleArn.map(value => value)
      )
    def destination: Optional[zio.aws.rum.model.MetricDestination]
    def destinationArn: Optional[DestinationArn]
    def iamRoleArn: Optional[IamRoleArn]
    def getDestination
        : ZIO[Any, AwsError, zio.aws.rum.model.MetricDestination] =
      AwsError.unwrapOptionField("destination", destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.MetricDestinationSummary
  ) extends zio.aws.rum.model.MetricDestinationSummary.ReadOnly {
    override val destination: Optional[zio.aws.rum.model.MetricDestination] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destination())
        .map(value => zio.aws.rum.model.MetricDestination.wrap(value))
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val iamRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.rum.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.MetricDestinationSummary
  ): zio.aws.rum.model.MetricDestinationSummary.ReadOnly = new Wrapper(impl)
}
