package zio.aws.rum.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.rum.model.primitives.{IamRoleArn, DestinationArn, AppMonitorName}
import scala.jdk.CollectionConverters._
final case class PutRumMetricsDestinationRequest(
    appMonitorName: AppMonitorName,
    destination: zio.aws.rum.model.MetricDestination,
    destinationArn: Optional[DestinationArn] = Optional.Absent,
    iamRoleArn: Optional[IamRoleArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.rum.model.PutRumMetricsDestinationRequest = {
    import PutRumMetricsDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.PutRumMetricsDestinationRequest
      .builder()
      .appMonitorName(AppMonitorName.unwrap(appMonitorName): java.lang.String)
      .destination(destination.unwrap)
      .optionallyWith(
        destinationArn.map(value =>
          DestinationArn.unwrap(value): java.lang.String
        )
      )(_.destinationArn)
      .optionallyWith(
        iamRoleArn.map(value => IamRoleArn.unwrap(value): java.lang.String)
      )(_.iamRoleArn)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.PutRumMetricsDestinationRequest.ReadOnly =
    zio.aws.rum.model.PutRumMetricsDestinationRequest.wrap(buildAwsValue())
}
object PutRumMetricsDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.rum.model.PutRumMetricsDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.PutRumMetricsDestinationRequest =
      zio.aws.rum.model.PutRumMetricsDestinationRequest(
        appMonitorName,
        destination,
        destinationArn.map(value => value),
        iamRoleArn.map(value => value)
      )
    def appMonitorName: AppMonitorName
    def destination: zio.aws.rum.model.MetricDestination
    def destinationArn: Optional[DestinationArn]
    def iamRoleArn: Optional[IamRoleArn]
    def getAppMonitorName: ZIO[Any, Nothing, AppMonitorName] =
      ZIO.succeed(appMonitorName)
    def getDestination: ZIO[Any, Nothing, zio.aws.rum.model.MetricDestination] =
      ZIO.succeed(destination)
    def getDestinationArn: ZIO[Any, AwsError, DestinationArn] =
      AwsError.unwrapOptionField("destinationArn", destinationArn)
    def getIamRoleArn: ZIO[Any, AwsError, IamRoleArn] =
      AwsError.unwrapOptionField("iamRoleArn", iamRoleArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.PutRumMetricsDestinationRequest
  ) extends zio.aws.rum.model.PutRumMetricsDestinationRequest.ReadOnly {
    override val appMonitorName: AppMonitorName =
      zio.aws.rum.model.primitives.AppMonitorName(impl.appMonitorName())
    override val destination: zio.aws.rum.model.MetricDestination =
      zio.aws.rum.model.MetricDestination.wrap(impl.destination())
    override val destinationArn: Optional[DestinationArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.destinationArn())
        .map(value => zio.aws.rum.model.primitives.DestinationArn(value))
    override val iamRoleArn: Optional[IamRoleArn] = zio.aws.core.internal
      .optionalFromNullable(impl.iamRoleArn())
      .map(value => zio.aws.rum.model.primitives.IamRoleArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.PutRumMetricsDestinationRequest
  ): zio.aws.rum.model.PutRumMetricsDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
