package zio.aws.rum.model
import zio.aws.rum.model.primitives.{Timestamp, RumEventIdString, JsonValue}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters._
final case class RumEvent(
    details: JsonValue,
    id: RumEventIdString,
    metadata: Optional[JsonValue] = Optional.Absent,
    timestamp: Timestamp,
    `type`: String
) {
  def buildAwsValue(): software.amazon.awssdk.services.rum.model.RumEvent = {
    import RumEvent.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.rum.model.RumEvent
      .builder()
      .details(JsonValue.unwrap(details): java.lang.String)
      .id(RumEventIdString.unwrap(id): java.lang.String)
      .optionallyWith(
        metadata.map(value => JsonValue.unwrap(value): java.lang.String)
      )(_.metadata)
      .timestamp(Timestamp.unwrap(timestamp): Instant)
      .`type`(`type`: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.rum.model.RumEvent.ReadOnly =
    zio.aws.rum.model.RumEvent.wrap(buildAwsValue())
}
object RumEvent {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.rum.model.RumEvent] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.rum.model.RumEvent = zio.aws.rum.model.RumEvent(
      details,
      id,
      metadata.map(value => value),
      timestamp,
      `type`
    )
    def details: JsonValue
    def id: RumEventIdString
    def metadata: Optional[JsonValue]
    def timestamp: Timestamp
    def `type`: String
    def getDetails: ZIO[Any, Nothing, JsonValue] = ZIO.succeed(details)
    def getId: ZIO[Any, Nothing, RumEventIdString] = ZIO.succeed(id)
    def getMetadata: ZIO[Any, AwsError, JsonValue] =
      AwsError.unwrapOptionField("metadata", metadata)
    def getTimestamp: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(timestamp)
    def getType: ZIO[Any, Nothing, String] = ZIO.succeed(`type`)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.rum.model.RumEvent
  ) extends zio.aws.rum.model.RumEvent.ReadOnly {
    override val details: JsonValue =
      zio.aws.rum.model.primitives.JsonValue(impl.details())
    override val id: RumEventIdString =
      zio.aws.rum.model.primitives.RumEventIdString(impl.id())
    override val metadata: Optional[JsonValue] = zio.aws.core.internal
      .optionalFromNullable(impl.metadata())
      .map(value => zio.aws.rum.model.primitives.JsonValue(value))
    override val timestamp: Timestamp =
      zio.aws.rum.model.primitives.Timestamp(impl.timestamp())
    override val `type`: String = impl.`type`(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.rum.model.RumEvent
  ): zio.aws.rum.model.RumEvent.ReadOnly = new Wrapper(impl)
}
